% bndy_ass
%
% This script fudges an assimilation error field to assimilate around
% the boundary.

%-------------------------------------------------------------------------------
% Get name of input file containing run parameters.
%-------------------------------------------------------------------------------

parmfiledef = 'bndy_ass.in';

parmfile = input (['Enter name of parameter input file [',parmfiledef, ...
                   ']: '],'s');
if isempty(parmfile)
   parmfile = parmfiledef;
end;

clear parmfiledef;

%-------------------------------------------------------------------------------
% Get run parameters.
%-------------------------------------------------------------------------------

ann_tic ('Reading input parameters');

[thick,errmin,errmax,gfile,ptmpl,pout,status] = fpass_parm (parmfile);

hms_toc;

if (status<0)
   disp (' ');
   disp ('***Error:  BNDY_ASS - unable to read parameter input file:');
   disp (['           ',setstr(34),parmfile,setstr(34)]);
   return;
end;

clear parmfile status;

%-------------------------------------------------------------------------------
% Construct error field.
%-------------------------------------------------------------------------------

ann_tic ('Setting Error mask');

[errp,errt,errv] = set_err (gfile,thick,errmin,errmax);

hms_toc;

clear gfile;

%-------------------------------------------------------------------------------
% Create assimilation file for boundary assimilation.
%-------------------------------------------------------------------------------

ann_tic ('Creating Boundary Assimilation file');

eval (['!cp ',ptmpl,' ',pout]);

ncid = netcdf (pout,'write');

nt = length(ncid('time'));
nz = length(ncid('level'));

for n = 1:nt

   ncid{'pbarerr'}(n,:,:) = errp;

   for k = 1:nz

      ncid{'temperr'}(n,:,:,k)    = errt;
      ncid{'salterr'}(n,:,:,k)    = errt;
      ncid{'vclinerr'}(n,:,:,k,1) = errv;
      ncid{'vclinerr'}(n,:,:,k,2) = errv;

   end;
end;

status = close (ncid);

hms_toc;
