function [cstmask,lncst,icst,jcst,errmsk] = get_trans_dat (gfile,thick);
%
% function [cstmask,lncst,icst,jcst,errmsk] = get_trans_dat (gfile,thick);
%
% This function extracts the coastal data and constructs a
% mask to create smooth transitions between coast & water.

%-------------------------------------------------------------------------------
% Get coastal data.
%-------------------------------------------------------------------------------

[tbath,vbath,dxt,dyt,metxt,metyt,dxu,dyu,metxu,metyu, ...
          cenlat,cstmask,landv,lncst,icst,jcst,nisle,status] = ...
                                                           get_grids (gfile,0);

clear tbath vbath dxt dyt metxt metyt dxu dyu metxu metyu
clear cenlat landv status gfile

%-------------------------------------------------------------------------------
% Construct smoothing mask.
%-------------------------------------------------------------------------------

[bpdist,btdist,bvdist,bzdist] = bndy_dist (cstmask,lncst,icst,jcst,'Coastal');

errmsk = ones(size(bpdist));
ind = find ((bpdist>0) & (bpdist<thick));
errmsk(ind) = 0;
