function errnew = set_trans_err (err,errmask,cstmask,lncst,icst,jcst);
%
% function errnew = set_trans_err (err,errmask,cstmask,lncst,icst,jcst);
%
% This function sets the transport streamfunction error to a constant
% along coastal boundaries and relaxes to the OI error field according
% to the error mask.

%-------------------------------------------------------------------------------
% Set transport streamfunction error to a constant along coasts.
%-------------------------------------------------------------------------------

errwork = setisle (err,(1:length(lncst)),lncst,icst,jcst);

%-------------------------------------------------------------------------------
% Set transport streamfunction error to a constant under land.
%-------------------------------------------------------------------------------

for n = 1:length(lncst)
   ind = find (cstmask==n);
   errwork(ind) = errwork(jcst(1,n),icst(1,n));
end;

%-------------------------------------------------------------------------------
% Create smooth transition.
%-------------------------------------------------------------------------------

errnew = smooth_under_iw (errwork,errmask);
