      program fakenest
c
c=======================================================================
c                                                                    ===
c  This program takes the output of a PE model run and overwrites a  ===
c  PE_initial file.                                                  ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
#ifndef sunfpe
c     GET_DIM,  GET_FLD,  GET_SCLR,  UDIEJOE,  WRT_FLD,  WRT_SCLR    ===
# else
c                                                                    ===
c     GET_DIM,  GET_FLD,  GET_SCLR,  MY_HANDLER,  UDIEJOE,  WRT_FLD, ===
c     WRT_SCLR                                                       ===
#endif
c                                                                    ===
c     netCDF:  NCCLOS,  NCOPN                                        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <fnparam.h>
#include <fncoast.h>
#include <netcdf.inc>
#include <netstat.h>
#include <domsdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      real    cm2deg,pi,re,sec2day
      integer baro,genscl,uvel,vvel,temp,salt
      parameter (genscl=0, uvel=1, temp=1, vvel=2,
     &           salt=2, baro=-1, sec2day=1.0/86400.0,
     &           pi=3.14159 26535 89793 23846, re=637131500.0)
      parameter (cm2deg=180.0/(re*pi))
#ifdef nestvclin
      integer zax
      parameter (zax=3)
#endif
#ifdef bioDuse
cjad - note that these must match those in the pemodel and peinitial
      integer idet,inh4,ino3,izoo,iqn3,iqn4,ichl
      parameter (ino3=3,iqn3=4,izoo=5,inh4=6,idet=7,ichl=8,iqn4=9)
#endif
#ifdef cod_model
cjad - note that these must match those in the pemodel and peinitial
      integer icod
      parameter (icod=10)
#endif
c
      real    fld(maxpt),fld2(maxpt),time,dt
#ifdef nestvclin
     &        ,dzin(maxpt),dzout(maxpt)
#endif
      integer err,ijmx,imt1,imt2,jmt1,jmt2,lev1,lev2,n,nshft,nst,tim0,
     &        tim1,tim2
#ifdef sunfpe
     &        ,ieeer,my_handler,ieee_handler
#endif
      integer mask(max2),msk2(max2),vmsk(max2),wk(max2,3)
      logical      dum,ismsk1,ismsk2,ispe
      character*80 outfile,infile
c
#ifdef sunfpe
      external my_handler
c
#endif
      data dum,ismsk1 /.false.,.false./
      data dt /0.0/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifdef sunfpe
c-----------------------------------------------------------------------
c  Enable floating point error flags.
c-----------------------------------------------------------------------
c
      ieeer = ieee_handler ('set','common',my_handler)
      if (ieeer .ne. 0) write (6,20)
c
#endif
c-----------------------------------------------------------------------
c  Get OA netCDF file names.
c-----------------------------------------------------------------------
c
      write (6,30) 'PE output'
      read (5,40) infile
c
      write (6,30) 'PE_initial'
      read (5,40) outfile
c
c-----------------------------------------------------------------------
c  Open netCDF files.
c-----------------------------------------------------------------------
c
      call ncpopt (ncverbos)
c
      ncid1 = ncopn (infile,ncnowrit,err)
      if (err.eq.0) then
         ncflg1 = 1
        else
         write (6,50) infile
         call udiejoe ('FAKENEST')
      end if
c
      ncid2 = ncopn (outfile,ncwrite,err)
      if (err.eq.0) then
         ncflg2 = 1
        else
         write (6,50) outfile
         call udiejoe ('FAKENEST')
      end if
c
c-----------------------------------------------------------------------
c  Find the size of the variables and the length of the time series
c  in both files.
c-----------------------------------------------------------------------
c
      call get_dim (ncid1,'tlon',infile,imt1)
      call get_dim (ncid1,'tlat',infile,jmt1)
      call getnedim (ncid1,'outlev',infile,lev1,ispe)
      if (.not.ispe) then
         call get_dim (ncid1,'level',infile,lev1)
         call getnedim (ncid1,'time0',infile,tim1,dum)
      end if
      if (.not.dum) call get_dim (ncid1,'time',infile,tim1)
c
      call get_dim (ncid2,'tlon',outfile,imt2)
      call get_dim (ncid2,'tlat',outfile,jmt2)
      call get_dim (ncid2,'level',outfile,lev2)
      call get_dim (ncid2,'time0',outfile,tim0)
      call get_dim (ncid2,'time',outfile,tim2)
c
c-----------------------------------------------------------------------
c  Check dimension sizes.
c-----------------------------------------------------------------------
c
      if (lev1.ne.lev2) write (6,60) 'nlev',lev1,'nlev',lev2
c
      if ((imt1*jmt1*lev1).gt.maxpt) write (6,70) imt1*jmt1*lev1,maxpt
      if ((imt2*jmt2*lev2).gt.maxpt) write (6,70) imt2*jmt2*lev2,maxpt
      if ((imt1*jmt1).gt.max2) write (6,72) imt1*jmt1,max2
c
      if ((lev1.ne.lev2).or.((imt1*jmt1*lev1).gt.maxpt).or.
     &             ((imt2*jmt2*lev2).gt.maxpt).or.((imt1*jmt1).gt.max2))
     &   call udiejoe ('FAKENEST')
c
      ijmx = max ( imt2 , jmt2)
c
c-----------------------------------------------------------------------
c  Inquire about the desired starting time index.
c-----------------------------------------------------------------------
c
      write (6,75) tim1
      read (5,*) nst
c
c-----------------------------------------------------------------------
c  Get horizontal grid parameters.
c-----------------------------------------------------------------------
c
      call get_isclr (ncid1,'coord',infile,1,crd1)
      call get_sclr  (ncid1,'rlngd',infile,1,lonc1)
      call get_sclr  (ncid1,'rlatd',infile,1,latc1)
      call get_sclr  (ncid1,'thetad',infile,1,thet1)
      if (ispe) then
         call get_sclr  (ncid1,'dxt',infile,1,dx1)
         if (crd1.ne.0) dx1 = dx1*cm2deg
         call get_sclr  (ncid1,'dyt',infile,1,dy1)
         if (crd1.ne.0) dy1 = dy1*cm2deg
       else
         call get_sclr  (ncid1,'gridx',infile,1,dx1)
         call get_sclr  (ncid1,'gridy',infile,1,dy1)
      end if
      call get_sclr  (ncid1,'delx',infile,1,dlx1)
      call get_sclr  (ncid1,'dely',infile,1,dly1)
c
      call get_isclr (ncid2,'coord',outfile,1,crd2)
      call get_sclr  (ncid2,'rlngd',outfile,1,lonc2)
      call get_sclr  (ncid2,'rlatd',outfile,1,latc2)
      call get_sclr  (ncid2,'thetad',outfile,1,thet2)
      call get_sclr  (ncid2,'gridx',outfile,1,dx2)
      call get_sclr  (ncid2,'gridy',outfile,1,dy2)
      call get_sclr  (ncid2,'delx',infile,1,dlx2)
      call get_sclr  (ncid2,'dely',infile,1,dly2)
c
c-----------------------------------------------------------------------
c  Get input land mask (if applicable).
c-----------------------------------------------------------------------
c
      if (ispe) then
         call get_mask (ncid1,'landt',infile,imt1,jmt1,mask,ismsk1)
         call get_mask (ncid1,'landv',infile,imt1,jmt1,vmsk,ismsk1)
      endif
c
      call get_mask (ncid2,'landt',outfile,imt2,jmt2,msk2,ismsk2)
      if (ismsk2) then
         call get_dim (ncid2,'ncseg',outfile,ncst)
         call get_dim (ncid2,'lcseg',outfile,mxlncs)
         call get_ivec (ncid2,'lencoast',outfile,ncst,lencst)
         call get_mask (ncid2,'icoast',outfile,mxlncs,ncst,icst,ismsk2)
         call get_mask (ncid2,'jcoast',outfile,mxlncs,ncst,jcst,ismsk2)
         call setcmsk (imt2,jmt2,msk2)
      endif
c
#ifdef nestvclin
c-----------------------------------------------------------------------
c  Get V-box thicknesses, to ensure baroclinicity.
c-----------------------------------------------------------------------
c
      call get_fld (ncid1,'vgrid3',infile,nst,imt1,jmt1,lev1,zax,fld)
      call get_thick (imt1,jmt1,lev1,fld,dzin)
      call get_fld (ncid2,'vgrid3',outfile,nst,imt2,jmt2,lev2,zax,fld)
      call get_thick (imt2,jmt2,lev2,fld,dzout)
c
#endif
c-----------------------------------------------------------------------
c  Take initial field from PE output and use it for initial and
c  starting boundary conditions.
c-----------------------------------------------------------------------
#if !defined cod_only & !defined nophys
c
      call get_fld (ncid1,'temp',infile,nst,imt1,jmt1,lev1,genscl,fld)
      if (ismsk1) call smooth_under (imt1,jmt1,lev1,fld,mask,1,max2,wk)
      call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'temp',outfile,1,imt2,jmt2,lev2,genscl,fld2)
      call get_bndy (3,imt2,jmt2,ijmx,lev2,fld2,fld)
      call wrt_bdy (ncid2,'tbry',outfile,1,imt2,jmt2,ijmx,lev2,temp,fld)
c
      call get_fld (ncid1,'salt',infile,nst,imt1,jmt1,lev1,genscl,fld)
      if (ismsk1) call smooth_under (imt1,jmt1,lev1,fld,mask,1,max2,wk)
      call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'salt',outfile,1,imt2,jmt2,lev2,genscl,fld2)
      call get_bndy (3,imt2,jmt2,ijmx,lev2,fld2,fld)
      call wrt_bdy (ncid2,'tbry',outfile,1,imt2,jmt2,ijmx,lev2,salt,fld)
c
#endif
#if defined bioDuse & !defined cod_only
      call get_fld (ncid1,'NO3',infile,nst,imt1,jmt1,lev1,genscl,fld)
      if (ismsk1) call smooth_under (imt1,jmt1,lev1,fld,mask,1,max2,wk)
      call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'NO3',outfile,1,imt2,jmt2,lev2,genscl,fld2)
      call get_bndy (3,imt2,jmt2,ijmx,lev2,fld2,fld)
      call wrt_bdy (ncid2,'tbry',outfile,1,imt2,jmt2,ijmx,lev2,ino3,fld)
c
      call get_fld(ncid1,'CELLNO3',infile,nst,imt1,jmt1,lev1,genscl,fld)
      if (ismsk1) call smooth_under (imt1,jmt1,lev1,fld,mask,1,max2,wk)
      call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld(ncid2,'CELLNO3',outfile,1,imt2,jmt2,lev2,genscl,fld2)
      call get_bndy (3,imt2,jmt2,ijmx,lev2,fld2,fld)
      call wrt_bdy (ncid2,'tbry',outfile,1,imt2,jmt2,ijmx,lev2,iqn3,fld)
c
      call get_fld (ncid1,'zoo',infile,nst,imt1,jmt1,lev1,genscl,fld)
      if (ismsk1) call smooth_under (imt1,jmt1,lev1,fld,mask,1,max2,wk)
      call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'zoo',outfile,1,imt2,jmt2,lev2,genscl,fld2)
      call get_bndy (3,imt2,jmt2,ijmx,lev2,fld2,fld)
      call wrt_bdy (ncid2,'tbry',outfile,1,imt2,jmt2,ijmx,lev2,izoo,fld)
c
      call get_fld (ncid1,'NH4',infile,nst,imt1,jmt1,lev1,genscl,fld)
      if (ismsk1) call smooth_under (imt1,jmt1,lev1,fld,mask,1,max2,wk)
      call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'NH4',outfile,1,imt2,jmt2,lev2,genscl,fld2)
      call get_bndy (3,imt2,jmt2,ijmx,lev2,fld2,fld)
      call wrt_bdy (ncid2,'tbry',outfile,1,imt2,jmt2,ijmx,lev2,inh4,fld)
c
      call get_fld (ncid1,'detritus',infile,nst,imt1,jmt1,lev1,genscl,
     &                                                              fld)
      if (ismsk1) call smooth_under (imt1,jmt1,lev1,fld,mask,1,max2,wk)
      call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'detritus',outfile,1,imt2,jmt2,lev2,genscl,
     &                                                             fld2)
      call get_bndy (3,imt2,jmt2,ijmx,lev2,fld2,fld)
      call wrt_bdy (ncid2,'tbry',outfile,1,imt2,jmt2,ijmx,lev2,idet,fld)
c
      call get_fld (ncid1,'CHL',infile,nst,imt1,jmt1,lev1,genscl,fld)
      if (ismsk1) call smooth_under (imt1,jmt1,lev1,fld,mask,1,max2,wk)
      call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'CHL',outfile,1,imt2,jmt2,lev2,genscl,fld2)
      call get_bndy (3,imt2,jmt2,ijmx,lev2,fld2,fld)
      call wrt_bdy (ncid2,'tbry',outfile,1,imt2,jmt2,ijmx,lev2,ichl,fld)
c
      call get_fld(ncid1,'CELLNH4',infile,nst,imt1,jmt1,lev1,genscl,fld)
      if (ismsk1) call smooth_under (imt1,jmt1,lev1,fld,mask,1,max2,wk)
      call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld(ncid2,'CELLNH4',outfile,1,imt2,jmt2,lev2,genscl,fld2)
      call get_bndy (3,imt2,jmt2,ijmx,lev2,fld2,fld)
      call wrt_bdy (ncid2,'tbry',outfile,1,imt2,jmt2,ijmx,lev2,iqn4,fld)
c
#endif
#ifdef cod_model
c
      call get_fld(ncid1,'cod',infile,nst,imt1,jmt1,lev1,genscl,fld)
      if (ismsk1) call smooth_under (imt1,jmt1,lev1,fld,mask,1,max2,wk)
      call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld(ncid2,'cod',outfile,1,imt2,jmt2,lev2,genscl,fld2)
      call get_bndy (3,imt2,jmt2,ijmx,lev2,fld2,fld)
      call wrt_bdy (ncid2,'tbry',outfile,1,imt2,jmt2,ijmx,lev2,icod,fld)
c
#endif
#if !defined cod_only & !defined nophys
      call get_fld (ncid1,'pbar',infile,nst,imt1,jmt1,1,baro,fld)
      if (ismsk1) call psi_under (imt1,jmt1,fld,mask,max2,wk)
      call mapfld (imt1,jmt1,1,fld,imt2,jmt2,fld2)
      if (ismsk2) call transunder (imt2,jmt2,fld2)
      call wrt_fld (ncid2,'pbar',outfile,1,imt2,jmt2,1,baro,fld2)
      call get_bndy (0,imt2,jmt2,ijmx,1,fld2,fld)
      call wrt_bdy (ncid2,'pbry',outfile,1,imt2,jmt2,ijmx,1,baro,fld)
c
      if (ispe) then
         call get_fld (ncid1,'qbar',infile,nst,imt1,jmt1,1,baro,fld)
         if (ismsk1) call smooth_under (imt1,jmt1,1,fld,vmsk,0,max2,wk)
         call mapfld (imt1,jmt1,1,fld,imt2,jmt2,fld2)
         call get_bndy (1,imt2,jmt2,ijmx,1,fld2,fld)
         call wrt_bdy (ncid2,'qbry',outfile,1,imt2,jmt2,ijmx,1,baro,fld)
      endif
c
      call get_fld (ncid1,'vclin',infile,nst,imt1,jmt1,lev1,uvel,fld)
# ifndef nestvclin
      if (ismsk1) call smooth_under (imt1,jmt1,lev1,fld,vmsk,2,max2,wk)
      call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
# else
      call scalvclin (imt1,jmt1,lev1,fld,dzin,fld2,'Multiply')
      if (ismsk1) call smooth_under (imt1,jmt1,lev1,fld2,vmsk,2,max2,wk)
      call mapfld (imt1,jmt1,lev1,fld2,imt2,jmt2,fld)
      call scalvclin (imt2,jmt2,lev2,fld,dzout,fld2,'Divide')
# endif
      call wrt_fld(ncid2,'vclin',outfile,1,imt2,jmt2,lev2,uvel,fld2)
      call get_bndy (2,imt2,jmt2,ijmx,lev2,fld2,fld)
      call wrt_bdy (ncid2,'vbry',outfile,1,imt2,jmt2,ijmx,lev2,uvel,fld)
c
      call get_fld (ncid1,'vclin',infile,nst,imt1,jmt1,lev1,vvel,fld)
# ifndef nestvclin
      if (ismsk1) call smooth_under (imt1,jmt1,lev1,fld,vmsk,2,max2,wk)
      call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
# else
      call scalvclin (imt1,jmt1,lev1,fld,dzin,fld2,'Multiply')
      if (ismsk1) call smooth_under (imt1,jmt1,lev1,fld2,vmsk,2,max2,wk)
      call mapfld (imt1,jmt1,lev1,fld2,imt2,jmt2,fld)
      call scalvclin (imt2,jmt2,lev2,fld,dzout,fld2,'Divide')
# endif
      call wrt_fld(ncid2,'vclin',outfile,1,imt2,jmt2,lev2,vvel,fld2)
      call get_bndy (2,imt2,jmt2,ijmx,lev2,fld2,fld)
      call wrt_bdy (ncid2,'vbry',outfile,1,imt2,jmt2,ijmx,lev2,vvel,fld)
c
#endif
c-----------------------------------------------------------------------
c  Take progressing field from PE output and use it for boundary
c  conditions.
c-----------------------------------------------------------------------
c
      if (ispe) then
         call get_sclr (ncid1,'time',infile,nst,dt)
         dt = dt*sec2day
         call get_sclr (ncid2,'time0',outfile,1,time)
         call wrt_sclr (ncid2,'time0',outfile,1,time+dt)
         call wrt_sclr (ncid2,'time',outfile,1,time+dt)
      end if
      nshft = 1-nst
c
      do n = nst+1, tim1
c
         call get_sclr (ncid1,'time',infile,n,dt)
         dt = dt*sec2day
         call wrt_sclr (ncid2,'time',outfile,n+nshft,time+dt)
c
         call get_fld (ncid1,'temp',infile,n,imt1,jmt1,lev1,genscl,fld)
         if(ismsk1) call smooth_under(imt1,jmt1,lev1,fld,mask,1,max2,wk)
         call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
         call get_bndy (3,imt2,jmt2,ijmx,lev2,fld2,fld)
         call wrt_bdy (ncid2,'tbry',outfile,n+nshft,imt2,jmt2,ijmx,lev2,
     &                                                         temp,fld)
c
         call get_fld (ncid1,'salt',infile,n,imt1,jmt1,lev1,genscl,fld)
         if(ismsk1) call smooth_under(imt1,jmt1,lev1,fld,mask,1,max2,wk)
         call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
         call get_bndy (3,imt2,jmt2,ijmx,lev2,fld2,fld)
         call wrt_bdy (ncid2,'tbry',outfile,n+nshft,imt2,jmt2,ijmx,lev2,
     &                                                         salt,fld)
c
         call get_fld (ncid1,'pbar',infile,n,imt1,jmt1,1,baro,fld)
         if (ismsk1) call psi_under (imt1,jmt1,fld,mask,max2,wk)
         call mapfld (imt1,jmt1,1,fld,imt2,jmt2,fld2)
         if (ismsk2) call transunder (imt2,jmt2,fld2)
         call get_bndy (0,imt2,jmt2,ijmx,1,fld2,fld)
         call wrt_bdy (ncid2,'pbry',outfile,n+nshft,imt2,jmt2,ijmx,1,
     &                                                         baro,fld)
c
         if (ispe) then
            call get_fld (ncid1,'qbar',infile,n,imt1,jmt1,1,baro,fld)
            call mapfld (imt1,jmt1,1,fld,imt2,jmt2,fld2)
            call get_bndy (1,imt2,jmt2,ijmx,1,fld2,fld)
            call wrt_bdy (ncid2,'qbry',outfile,n+nshft,imt2,jmt2,ijmx,1,
     &                                                         baro,fld)
         end if
c
         call get_fld (ncid1,'vclin',infile,n,imt1,jmt1,lev1,uvel,fld)
#ifndef nestvclin
         call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
# else
         call scalvclin (imt1,jmt1,lev1,fld,dzin,fld2,'Multiply')
         call mapfld (imt1,jmt1,lev1,fld2,imt2,jmt2,fld)
         call scalvclin (imt2,jmt2,lev2,fld,dzout,fld2,'Divide')
#endif
         call get_bndy (2,imt2,jmt2,ijmx,lev2,fld2,fld)
         call wrt_bdy (ncid2,'vbry',outfile,n+nshft,imt2,jmt2,ijmx,lev2,
     &                                                         uvel,fld)
c
         call get_fld (ncid1,'vclin',infile,n,imt1,jmt1,lev1,vvel,fld)
#ifndef nestvclin
         call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
# else
         call scalvclin (imt1,jmt1,lev1,fld,dzin,fld2,'Multiply')
         call mapfld (imt1,jmt1,lev1,fld2,imt2,jmt2,fld)
         call scalvclin (imt2,jmt2,lev2,fld,dzout,fld2,'Divide')
#endif
         call get_bndy (2,imt2,jmt2,ijmx,lev2,fld2,fld)
         call wrt_bdy (ncid2,'vbry',outfile,n+nshft,imt2,jmt2,ijmx,lev2,
     &                                                         vvel,fld)
c
      end do
c
c-----------------------------------------------------------------------
c  Close netCDF files.
c-----------------------------------------------------------------------
c
      call ncclos (ncid1,err)
      if (err.eq.0) then
         ncflg1 = 0
        else
         write (6,80) outfile
         call udiejoe ('FAKENEST')
      end if
c
      call ncclos (ncid2,err)
      if (err.eq.0) then
         ncflg2 = 0
        else
         write (6,80) infile
         call udiejoe ('FAKENEST')
      end if
c
      write (6,90)
c
      stop
c
#ifdef sunfpe
 20   format (/'+++ Warning:  ieee_handler cannot set my_handler'/)
#endif
 30   format (/'Enter name of ',a,' file: ')
 40   format (a)
 50   format(/'*** Error:  FAKENEST - unable to open file:'/12x,1h",a,
     &                                                              1h")
 60   format (/'*** Error:  FAKENEST - incompatible dimensions:'/12x,
     &                    'file1 ',a,' = ',i10/12x,'file2 ',a,' = ',i10)
 70   format (/'*** Error:  FAKENEST - too many grid points:'/12x,
     &          'im*jm*nlev = ',i10/17x,'maxpt = ',i10/12x,'Recompile ',
     &        'FAKENEST with the larger value for maxpt and try again.')
 72   format (/'*** Error:  FAKENEST - too many grid points:'/12x,
     &          'im*jm = ',i10/17x,'max2 = ',i10/12x,'Recompile ',
     &        'FAKENEST with the larger value for max2 and try again.')
 75   format (/'Enter starting time index  [1, ',i4,']: ')
 80   format (/'*** Error:  FAKENEST - unable to close file:'/12x,1h",a,
     &                                                              1h")
 90   format (/'FAKENEST  DONE')
c
      end
