      subroutine get_thick (nx,ny,nz,z,dz)
c
c-----------------------------------------------------------------------
c     This routine computes the box thicknesses from the mid-level     |
c     depths.                                                          |
c                                                                      |
c     Calls:  none                                                     |
c                                                                      |
c     Input:                                                           |
c                                                                      |
c        nx...The number of x-grid points.                             |
c        ny...The number of y-grid points.                             |
c        nz...The number of model levels.                              |
c        z....The depths in the middle of the vertical boxes.          |
c                                                                      |
c     Output:                                                          |
c                                                                      |
c        dz...The box thicknesses.                                     |
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c     Local data.                                                      |
c-----------------------------------------------------------------------
c
      integer i,j,k,nx,ny,nz
      real c2,dz(nz,nx,ny),z(nz,nx,ny)
c
      parameter (c2=2.0)
c
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
c-----------------------------------------------------------------------
c     Compute box thicknesses.                                         |
c-----------------------------------------------------------------------
c
      do 20 j = 1, ny
      do 20 i = 1, nx
         dz(1,i,j) = c2*z(1,i,j)
         do 10 k = 2, nz
            dz(k,i,j) = c2*(z(k,i,j)-z(k-1,i,j)) - dz(k-1,i,j)
 10      continue
 20   continue
c
      return
      end
