      subroutine get_time0 (ncin,inname,ncout,outname,t0)
c
c=======================================================================
c                                                                    ===
c  This routine determines the starting time for output.             ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NCIN      Input file identifier (PE output).     (integer)     ===
c     INNAME    Name of input file.                    (string)      ===
c     NCOUT     Output file identifier (PE_initial).   (integer)     ===
c     OUTNAME   Name of input file.                    (string)      ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     T0        Starting time.   (real; modified Julian days)        ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     ALL_UC,  JULIAN,  LENGTH,  UDIEJOE                             ===
c                                                                    ===
c     netCDF:  NCAGTC,  NCVGT1,  NCVID                               ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <netcdf.inc>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      real r24,r60
      parameter (r24=1.0/24.0, r60=1.0/60.0)
c
      integer err,hr,idy,jdy,mn,mo,ncin,ncout,sbn,sc,sind,sln,snd,varid,
     &        vbn,vln,vnd,yr
      real        dy,frac,t0
      character*6 varname
      character*(*) inname,outname
      character*256 string,wkstr
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Look for initial time in units string in PE file (COARDS convention).
c-----------------------------------------------------------------------
c
c  Look for time variable.
c
      varname = 'time'
      call length (varname,vln,vbn,vnd)
      varid = ncvid (ncin,varname(vbn:vnd),err)
c
      if (err.ne.0) then
         call length (inname,sln,sbn,snd)
         write (6,10) varname(vbn:vnd),inname(sbn:snd)
         call udiejoe ('GET_TIME0')
      end if
c
c  Read time variable units.
c
      call ncagtc (ncin,varid,'units',string,len(string),err)
c
      if (err.ne.0) then
         varname = 'time:units'
         call length (varname,vln,vbn,vnd)
         call length (inname,sln,sbn,snd)
         write (6,30) varname(vbn:vnd),inname(sbn:snd)
         call udiejoe ('GET_TIME0')
      end if
c
c  If units contain starting time data, parse initial time and return.
c
      call all_uc (string,wkstr)
c
      sind = index (wkstr,'SINCE')
c
      if (sind.gt.0) then
         call length (wkstr,sln,sbn,snd)
         call length (wkstr((sind+5):snd),vln,vbn,vnd)
         sind = sind + 5 + vbn - 1
         read (wkstr(sind:snd),05) yr,mo,idy,hr,mn,sc
  05     format (i4,5(1x,i2))
         dy = ((float(sc)*r60+float(mn))*r60+float(hr))*r24 + float(idy)
         call julian (dy,mo,yr,jdy,frac)
         t0 = frac + float(jdy)
         return
      end if
c
c-----------------------------------------------------------------------
c  Look for initial time variable in PE file.
c-----------------------------------------------------------------------
c
c  Try the name I was using in ASCOT02.
c
      varname = 'time0'
      call length (varname,vln,vbn,vnd)
      varid = ncvid (ncin,varname(vbn:vnd),err)
c
c  Try the name Pierre was using.
c
      if (err.ne.0) then
         varname = 'dstart'
         call length (varname,vln,vbn,vnd)
         varid = ncvid (ncin,varname(vbn:vnd),err)
      end if
c
c  If either name was found, read the time and return.
c
      if (err.eq.0) then
         call ncvgt1 (ncin,varid,1,t0,err)
         if (err.ne.0) then
            call length (inname,sln,sbn,snd)
            write (6,20) varname(vbn:vnd),inname(sbn:snd)
            call udiejoe ('GET_TIME0')
         end if
         return
      end if
c
c-----------------------------------------------------------------------
c  Take initial time variable from PE_initial file.
c-----------------------------------------------------------------------
c
c  Look for initial time variable.
c
      varname = 'time0'
      call length (varname,vln,vbn,vnd)
      varid = ncvid (ncout,varname(vbn:vnd),err)
c
      if (err.ne.0) then
         call length (outname,sln,sbn,snd)
         write (6,10) varname(vbn:vnd),outname(sbn:snd)
         call udiejoe ('GET_TIME0')
      end if
c
c  Read initial time variable.
c
      call ncvgt1 (ncout,varid,1,t0,err)
c
      if (err.ne.0) then
         call length (outname,sln,sbn,snd)
         write (6,20) varname(vbn:vnd),outname(sbn:snd)
         call udiejoe ('GET_TIME0')
      end if
c
      return
c
 10   format (/'*** Error:  GET_TIME0 - unable to find variable ',
     &                              1h",a,1h",' in file:'/12x,1h",a,1h")
 20   format (/'*** Error:  GET_TIME0 - unable to read variable ',
     &                              1h",a,1h",' in file:'/12x,1h",a,1h")
 30   format (/'*** Error:  GET_TIME0 - unable to read attribute ',
     &                              1h",a,1h",' in file:'/12x,1h",a,1h")
c
      end
