      program peout2ass
c
c-----------------------------------------------------------------------
c     This program takes the output of a PE model run and overwrites a |
c     PE_initial assimilatoin file.                                    |
c                                                                      |
#ifndef sunfpe
c            Calls:  get_dim, get_fld, get_sclr, udiejoe, wrt_fld,     |
c                    wrt_sclr                                          |
# else
c            Calls:  get_dim, get_fld, get_sclr, my_handler, udiejoe,  |
c                    wrt_fld, wrt_sclr                                 |
#endif
c     netCDF Calls:  ncclos, ncopn                                     |
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c     Global data.                                                     |
c-----------------------------------------------------------------------
c
#include <netcdf.inc>
#include <netstat.h>
c
c-----------------------------------------------------------------------
c     Local data.                                                      |
c-----------------------------------------------------------------------
c
      real    sec2day
      integer maxpt,genscl,uvel,vvel,temp,salt,baro
      parameter (maxpt=209*180*16, genscl=0, uvel=1, temp=1, vvel=2,
     &           salt=2, baro=-1, sec2day=1.0/86400.0)
c
      real    fld(maxpt),fld2(maxpt),time,dt
      integer err,ijmx,imt1,imt2,jmt1,jmt2,lev1,lev2,nst,tim0,tim1
#ifdef sunfpe
     &        ,ieeer,my_handler,ieee_handler
#endif
      character*80 outfile,infile
c
#ifdef sunfpe
      external my_handler
c
#endif
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
#ifdef sunfpe
c-----------------------------------------------------------------------
c     Enable floating point error flags.                               |
c-----------------------------------------------------------------------
c
      ieeer = ieee_handler ('set','common',my_handler)
      if (ieeer .ne. 0) write (6,20)
c
#endif
c-----------------------------------------------------------------------
c     Get OA netCDF file names.                                        |
c-----------------------------------------------------------------------
c
      write (6,30) 'PE output'
      read (5,40) infile
c
      write (6,30) 'PE_initial'
      read (5,40) outfile
c
c-----------------------------------------------------------------------
c     Open netCDF files.                                               |
c-----------------------------------------------------------------------
c
      call ncpopt (ncverbos)
c
      ncid1 = ncopn (infile,ncnowrit,err)
      if (err.eq.0) then
         ncflg1 = 1
        else
         write (6,50) infile
         call udiejoe ('PEOUT2ASS')
      end if
c
      ncid2 = ncopn (outfile,ncwrite,err)
      if (err.eq.0) then
         ncflg2 = 1
        else
         write (6,50) outfile
         call udiejoe ('PEOUT2ASS')
      end if
c
c-----------------------------------------------------------------------
c     Find the size of the variables and the length of the time series |
c     in both files.                                                   |
c-----------------------------------------------------------------------
c
      call get_dim (ncid1,'tlon',infile,imt1)
      call get_dim (ncid1,'tlat',infile,jmt1)
      call get_dim (ncid1,'outlev',infile,lev1)
      call get_dim (ncid1,'time',infile,tim1)
c
      call get_dim (ncid2,'tlon',outfile,imt2)
      call get_dim (ncid2,'tlat',outfile,jmt2)
      call get_dim (ncid2,'level',outfile,lev2)
      call get_dim (ncid2,'time',outfile,tim0)
c
c-----------------------------------------------------------------------
c     Check dimension sizes.                                           |
c-----------------------------------------------------------------------
c
      if (lev1.ne.lev2) write (6,60) 'nlev',lev1,'nlev',lev2
c
      if ((imt1*jmt1*lev1).gt.maxpt) write (6,70) imt1*jmt1*lev1,maxpt
      if ((imt2*jmt2*lev2).gt.maxpt) write (6,70) imt2*jmt2*lev2,maxpt
c
      if ((lev1.ne.lev2).or.((imt1*jmt1*lev1).gt.maxpt).or.
     &                                  ((imt2*jmt2*lev2).gt.maxpt))
     &   call udiejoe ('PEOUT2ASS')
c
      ijmx = max ( imt2 , jmt2)
c
c-----------------------------------------------------------------------
c     Inquire about the desired starting time index.                   |
c-----------------------------------------------------------------------
c
      write (6,75) tim1
      read (5,*) nst
c
c-----------------------------------------------------------------------
c     Take final field from PE output and use it for first             |
c     assimilation field.                                              |
c-----------------------------------------------------------------------
#if !defined cod_only & !defined nophys
c
      call get_sclr (ncid1,'time',infile,nst,dt)
      dt = dt*sec2day
      call get_sclr (ncid2,'time',outfile,1,time)
      call wrt_sclr (ncid2,'time',outfile,1,time+dt)
c
      call get_fld (ncid1,'temp',infile,nst,imt1,jmt1,lev1,genscl,fld)
      call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'temp',outfile,1,imt2,jmt2,lev2,genscl,fld2)
c
      call get_fld (ncid1,'salt',infile,nst,imt1,jmt1,lev1,genscl,fld)
      call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'salt',outfile,1,imt2,jmt2,lev2,genscl,fld2)
c
#endif
#if defined bioDuse & !defined cod_only
      call get_fld (ncid1,'NO3',infile,nst,imt1,jmt1,lev1,genscl,fld)
      call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'NO3',outfile,1,imt2,jmt2,lev2,genscl,fld2)
c
      call get_fld (ncid1,'CELLNO3',infile,nst,imt1,jmt1,lev1,genscl,
     &                                                              fld)
      call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'CELLNO3',outfile,1,imt2,jmt2,lev2,genscl,
     &                                                             fld2)
c
      call get_fld (ncid1,'zoo',infile,nst,imt1,jmt1,lev1,genscl,fld)
      call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'zoo',outfile,1,imt2,jmt2,lev2,genscl,fld2)
c
      call get_fld (ncid1,'NH4',infile,nst,imt1,jmt1,lev1,genscl,fld)
      call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'NH4',outfile,1,imt2,jmt2,lev2,genscl,fld2)
c
      call get_fld (ncid1,'detritus',infile,nst,imt1,jmt1,lev1,genscl,
     &                                                              fld)
      call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'detritus',outfile,1,imt2,jmt2,lev2,genscl,
     &                                                             fld2)
c
      call get_fld (ncid1,'CHL',infile,nst,imt1,jmt1,lev1,genscl,fld)
      call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'CHL',outfile,1,imt2,jmt2,lev2,genscl,fld2)
c
      call get_fld (ncid1,'CELLNH4',infile,nst,imt1,jmt1,lev1,genscl,
     &                                                              fld)
      call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'CELLNH4',outfile,1,imt2,jmt2,lev2,genscl,
     &                                                             fld2)
c
#endif
#ifdef cod_model
c
      call get_fld (ncid1,'cod',infile,nst,imt1,jmt1,lev1,genscl,fld)
      call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'cod',outfile,1,imt2,jmt2,lev2,genscl,fld2)
c
#endif
#if !defined cod_only & !defined nophys
      call get_fld (ncid1,'pbar',infile,nst,imt1,jmt1,1,baro,fld)
      call subsam (imt1,jmt1,1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'pbar',outfile,1,imt2,jmt2,1,baro,fld2)
c
      call get_fld (ncid1,'vclin',infile,nst,imt1,jmt1,lev1,uvel,fld)
      call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld(ncid2,'vclin',outfile,1,imt2,jmt2,lev2,uvel,fld2)
c
      call get_fld (ncid1,'vclin',infile,nst,imt1,jmt1,lev1,vvel,fld)
      call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
      call wrt_fld(ncid2,'vclin',outfile,1,imt2,jmt2,lev2,vvel,fld2)
c
#endif
c-----------------------------------------------------------------------
c     Close netCDF files.                                              |
c-----------------------------------------------------------------------
c
      call ncclos (ncid1,err)
      if (err.eq.0) then
         ncflg1 = 0
        else
         write (6,80) outfile
         call udiejoe ('PEOUT2ASS')
      end if
c
      call ncclos (ncid2,err)
      if (err.eq.0) then
         ncflg2 = 0
        else
         write (6,80) infile
         call udiejoe ('PEOUT2ASS')
      end if
c
      write (6,90)
c
      stop
c
#ifdef sunfpe
 20   format (/'+++ Warning:  ieee_handler cannot set my_handler'/)
#endif
 30   format (/'Enter name of ',a,' file: ',$)
 40   format (a)
 50   format(/'*** Error:  PEOUT2ASS - unable to open file:'/12x,1h",a,
     &                                                              1h")
 60   format (/'*** Error:  PEOUT2ASS - incompatible dimensions:'/12x,
     &                    'file1 ',a,' = ',i10/12x,'file2 ',a,' = ',i10)
 70   format (/'*** Error:  PEOUT2ASS - too many grid points:'/12x,
     &          'im*jm*nlev = ',i10/17x,'maxpt = ',i10/12x,'Recompile ',
     &       'PEOUT2ASS with the larger value for maxpt and try again.')
 75   format (/'Enter starting time index  [1, ',i4,']: ',$)
 80   format (/'*** Error:  PEOUT2ASS - unable to close file:'/12x,1h",a
     &                                                             ,1h")
 90   format (/'PEOUT2ASS  DONE')
c
      end
