      program peout2in
c
c=======================================================================
c                                                                    ===
c  This program takes the output of a PE model run and overwrites a  ===
c  PE_initial file.                                                  ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
#ifndef sunfpe
c     GET_DIM,  GET_FLD,  GET_SCLR,  UDIEJOE,  WRT_FLD,  WRT_SCLR    ===
# else
c     GET_DIM,  GET_FLD,  GET_SCLR,  MY_HANDLER,  UDIEJOE,  WRT_FLD, ===
c     WRT_SCLR                                                       ===
#endif
c     netCDF:  NCCLOS,  NCOPN                                        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <netcdf.inc>
#include <netstat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      real    sec2day
      integer maxpt,genscl,baro,trcnd,trcst
      parameter (maxpt=209*180*16, genscl=0, baro=-1,
     &           sec2day=1.0/86400.0)
#if !defined bioDuse & !defined cod_model
      parameter (trcnd=2)
#elif !defined cod_model
      parameter (trcnd=9)
#else
      parameter (trcnd=10)
#endif
#if !defined nophys & !defined cod_only
      parameter (trcst=1)
#elif !defined cod_only
      parameter (trcst=3)
#else
      parameter (trcst=10)
#endif
c
      real    t0
#if !defined cod_only & !defined nophys
     &        ,dt
#endif
      real    fld(maxpt),fld2(maxpt),xymrat(maxpt),yxmrat(maxpt)
      integer err,ijmx,imt1,imt2,jmt1,jmt2,lev1,lev2,n,nnd,nst,tim0,
     &        tim1,tim2,trcind
#if !defined cod_only & !defined nophys
     &        ,velind
#endif
#ifdef sunfpe
     &        ,ieeer,my_handler,ieee_handler
#endif
      integer mask(maxpt)
#if !defined cod_only & !defined nophys
     &        ,mwk(maxpt)
#endif
      logical      ismsk
      character*80 outfile,infile
      character*47 trcnam(10)
c
#ifdef sunfpe
      external my_handler
c
#endif
cjad - note that the order of the names must match those in the pemodel
c      and peinitial
c
      data trcnam(1) /'temp                                           '/
      data trcnam(2) /'salt                                           '/
      data trcnam(3) /'NO3                                            '/
      data trcnam(4) /'CELLNO3                                        '/
      data trcnam(5) /'zoo                                            '/
      data trcnam(6) /'NH4                                            '/
      data trcnam(7) /'detritus                                       '/
      data trcnam(8) /'CHL                                            '/
      data trcnam(9) /'CELLNH4                                        '/
      data trcnam(10)/'cod                                            '/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifdef sunfpe
c-----------------------------------------------------------------------
c  Enable floating point error flags.
c-----------------------------------------------------------------------
c
      ieeer = ieee_handler ('set','common',my_handler)
      if (ieeer .ne. 0) write (6,20)
c
#endif
c-----------------------------------------------------------------------
c  Get OA netCDF file names.
c-----------------------------------------------------------------------
c
      write (6,30) 'PE output'
      read (5,40) infile
c
      write (6,30) 'PE_initial'
      read (5,40) outfile
c
c-----------------------------------------------------------------------
c  Open netCDF files.
c-----------------------------------------------------------------------
c
      call ncpopt (ncverbos)
c
      ncid1 = ncopn (infile,ncnowrit,err)
      if (err.eq.0) then
         ncflg1 = 1
        else
         write (6,50) infile
         call udiejoe ('PEOUT2IN')
      end if
c
      ncid2 = ncopn (outfile,ncwrite,err)
      if (err.eq.0) then
         ncflg2 = 1
        else
         write (6,50) outfile
         call udiejoe ('PEOUT2IN')
      end if
c
c-----------------------------------------------------------------------
c  Find the size of the variables and the length of the time series
c  in both files.
c-----------------------------------------------------------------------
c
      call get_dim (ncid1,'tlon',infile,imt1)
      call get_dim (ncid1,'tlat',infile,jmt1)
      call get_dim (ncid1,'outlev',infile,lev1)
      call get_dim (ncid1,'time',infile,tim1)
c
      call get_dim (ncid2,'tlon',outfile,imt2)
      call get_dim (ncid2,'tlat',outfile,jmt2)
      call get_dim (ncid2,'level',outfile,lev2)
      call get_dim (ncid2,'time0',outfile,tim0)
      call get_dim (ncid2,'time',outfile,tim2)
c
c-----------------------------------------------------------------------
c  Check dimension sizes.
c-----------------------------------------------------------------------
c
      if (lev1.ne.lev2) write (6,60) 'nlev',lev1,'nlev',lev2
c
      if ((imt1*jmt1*lev1).gt.maxpt) write (6,70) imt1*jmt1*lev1,maxpt
      if ((imt2*jmt2*lev2).gt.maxpt) write (6,70) imt2*jmt2*lev2,maxpt
c
      if ((lev1.ne.lev2).or.((imt1*jmt1*lev1).gt.maxpt).or.
     &                                  ((imt2*jmt2*lev2).gt.maxpt))
     &   call udiejoe ('PEOUT2IN')
c
      ijmx = max ( imt2 , jmt2)
c
c-----------------------------------------------------------------------
c  Inquire about the desired starting time index.
c-----------------------------------------------------------------------
c
      write (6,80) tim1
      read (5,*) nst
c
      write (6,90) nst,tim1
      read (5,*) nnd
c
c-----------------------------------------------------------------------
c  Get initial time.
c-----------------------------------------------------------------------
c
      call get_time0 (ncid1,infile,ncid2,outfile,t0)
c
c-----------------------------------------------------------------------
c  Get spacing/metric data.
c-----------------------------------------------------------------------
c
      call get_dxy (ncid1,infile,imt1,jmt1,xymrat,yxmrat)
      call get_mask (ncid1,'landt',infile,imt1,jmt1,mask,ismsk)
c
c-----------------------------------------------------------------------
c  Take final field from PE output and use it for initial and
c  boundary conditions.
c-----------------------------------------------------------------------
#if !defined cod_only & !defined nophys
c
c  Transfer time.
c
      call get_sclr (ncid1,'time',infile,nst,dt)
      dt = dt*sec2day
      call wrt_sclr (ncid2,'time0',outfile,1,t0+dt)
      call wrt_sclr (ncid2,'time',outfile,1,t0+dt)
      do n = (nst+1), nnd
         call get_sclr (ncid1,'time',infile,n,dt)
         dt = dt*sec2day
         call wrt_sclr (ncid2,'time',outfile,(n+1-nst),t0+dt)
      end do
#endif
c
c  Transfer tracers.
c
      do trcind = trcst, trcnd
         call get_fld (ncid1,trcnam(trcind),infile,nst,imt1,jmt1,lev1,
     &                                                       genscl,fld)
         call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
         call wrt_fld (ncid2,trcnam(trcind),outfile,1,imt2,jmt2,lev2,
     &                                                      genscl,fld2)
         call get_bndy (3,imt2,jmt2,ijmx,lev2,fld2,fld)
         call wrt_bdy (ncid2,'tbry',outfile,1,imt2,jmt2,ijmx,lev2,
     &                                                       trcind,fld)
         do n = (nst+1), nnd
            call get_fld (ncid1,trcnam(trcind),infile,n,imt1,jmt1,lev1,
     &                                                       genscl,fld)
            call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
            call get_bndy (3,imt2,jmt2,ijmx,lev2,fld2,fld)
            call wrt_bdy (ncid2,'tbry',outfile,(n+1-nst),imt2,jmt2,ijmx,
     &                                                  lev2,trcind,fld)
         end do
      end do
#if !defined cod_only & !defined nophys
c
c  Transfer transport streamfunction.
c
      call get_fld (ncid1,'pbar',infile,nst,imt1,jmt1,1,baro,fld)
      call subsam (imt1,jmt1,1,fld,imt2,jmt2,fld2)
      call wrt_fld (ncid2,'pbar',outfile,1,imt2,jmt2,1,baro,fld2)
      call get_bndy (0,imt2,jmt2,ijmx,1,fld2,fld)
      call wrt_bdy (ncid2,'pbry',outfile,1,imt2,jmt2,ijmx,1,baro,fld)
      do n = (nst+1), nnd
         call get_fld (ncid1,'pbar',infile,n,imt1,jmt1,1,baro,fld)
         call subsam (imt1,jmt1,1,fld,imt2,jmt2,fld2)
         call get_bndy (0,imt2,jmt2,ijmx,1,fld2,fld)
         call wrt_bdy (ncid2,'pbry',outfile,(n+1-nst),imt2,jmt2,ijmx,1,
     &                                                         baro,fld)
      end do
c
c  Transfer barotropic vorticity tendency (BCs only).
c
      do n = nst, nnd
         call get_vort (ncid1,infile,n,tim1,imt1,jmt1,baro,xymrat,yxmrat
     &                  ,ismsk,mask,mwk,fld,fld2)
         call subsam (imt1,jmt1,1,fld,imt2,jmt2,fld2)
         call get_bndy (1,imt2,jmt2,ijmx,1,fld2,fld)
         call wrt_bdy (ncid2,'qbry',outfile,(n+1-nst),imt2,jmt2,ijmx,1,
     &                                                         baro,fld)
      end do
c
c  Transfer baroclinic velocity.
c
      do velind = 1, 2
         call get_fld (ncid1,'vclin',infile,nst,imt1,jmt1,lev1,velind,
     &                                                              fld)
         call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
         call wrt_fld (ncid2,'vclin',outfile,1,imt2,jmt2,lev2,velind,
     &                                                             fld2)
         call get_bndy (2,imt2,jmt2,ijmx,lev2,fld2,fld)
         call wrt_bdy (ncid2,'vbry',outfile,1,imt2,jmt2,ijmx,lev2,
     &                                                       velind,fld)
         do n = (nst+1), nnd
            call get_fld (ncid1,'vclin',infile,n,imt1,jmt1,lev1,velind,
     &                                                              fld)
            call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
            call get_bndy (2,imt2,jmt2,ijmx,lev2,fld2,fld)
            call wrt_bdy (ncid2,'vbry',outfile,(n+1-nst),imt2,jmt2,ijmx,
     &                                                  lev2,velind,fld)
         end do
      end do
#endif
c
c-----------------------------------------------------------------------
c  Close netCDF files.
c-----------------------------------------------------------------------
c
      call ncclos (ncid1,err)
      if (err.eq.0) then
         ncflg1 = 0
        else
         write (6,100) outfile
         call udiejoe ('PEOUT2IN')
      end if
c
      call ncclos (ncid2,err)
      if (err.eq.0) then
         ncflg2 = 0
        else
         write (6,100) infile
         call udiejoe ('PEOUT2IN')
      end if
c
      write (6,110)
c
      stop
c
#ifdef sunfpe
 20   format (/'+++ Warning:  ieee_handler cannot set my_handler'/)
#endif
 30   format (/'Enter name of ',a,' file: ',$)
 40   format (a)
 50   format(/'*** Error:  PEOUT2IN - unable to open file:'/12x,1h",a,
     &                                                              1h")
 60   format (/'*** Error:  PEOUT2IN - incompatible dimensions:'/12x,
     &                    'file1 ',a,' = ',i10/12x,'file2 ',a,' = ',i10)
 70   format (/'*** Error:  PEOUT2IN - too many grid points:'/12x,
     &          'im*jm*nlev = ',i10/17x,'maxpt = ',i10/12x,'Recompile ',
     &        'PEOUT2IN with the larger value for maxpt and try again.')
 80   format (/'Enter starting time index  [1, ',i4,']: ',$)
 90   format (/'Enter ending time index    [',i4,', ',i4,']: ',$)
100   format (/'*** Error:  PEOUT2IN - unable to close file:'/12x,1h",a,
     &                                                              1h")
110   format (/'PEOUT2IN  DONE')
c
      end
