      subroutine psi_under (nx,ny,vals,mask,mxwk,wk)
c
c=======================================================================
c                                                                    ===
c  This routine replaces values of the transport streamfunction      ===
c  under the land mask with the values at the nearest boundary point ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NX........Number of points in x-direction.   (integer)         ===
c     NY........Number of points in y-direction.   (integer)         ===
c     VALS......Initial values.                    (real array)      ===
c     MASK......Land mask.                         (integer array)   ===
c     MXWK......Size of WK, min=(NX*NY).           (integer)         ===
c     WK........Workspace of size (MXWK).          (integer array)   ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     VALS......Values smoothly extended under mask.    (real array) ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer d,dp,i,im,ip,j,jm,jp,mxwk,n,nx,ny
      integer mask(nx,ny),wk(mxwk)
      real    vals(nx,ny)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifndef ignoremask
c-----------------------------------------------------------------------
c  Create mask of boundary nodes.
c-----------------------------------------------------------------------
c
      do 10 j = 1, ny
         jm = max (j-1, 1)
         jp = min (j+1, ny)
         do 10 i = 1, nx
            im = max (i-1, 1)
            ip = min (i+1, nx)
            n = i + (j-1)*nx
            wk(n) = mask(i,j) - mask(im,jp)*mask(i,jp)*mask(ip,jp)*
     &                          mask(im,j )*mask(i,j )*mask(ip,j )*
     &                          mask(im,jm)*mask(i,jm)*mask(ip,jm)
 10   continue
c
c-----------------------------------------------------------------------
c  Loop over all points, updating values under the mask.
c-----------------------------------------------------------------------
c
      do 30 j = 1, ny
      do 30 i = 1, nx
c
         if (mask(i,j).eq.0) then
c
c           ------------------------------------
c           --- Find nearest boundary point. ---
c           ------------------------------------
c
            dp = nx**2 + ny**2
c
            do 20 jm = 1, ny
            do 20 im = 1, nx
               d = (im-i)**2 + (jm-j)**2
               n = im + (jm-1)*nx
               if ((wk(n).eq.1).and.(d.lt.dp)) then
                  ip = im
                  jp = jm
                  dp = d
               end if
 20         continue
c
c           ------------------------------------------------------------
c           --- Replace value under mask with nearest boundary value ---
c           ------------------------------------------------------------
c
            vals(i,j) = vals(ip,jp)
c
         end if
c
 30   continue
c
#endif
      return
      end
