      subroutine rinsert (new_elem,array,n,nmax,error)
c
c-------------------------------------------------------------------------------
c     This subroutine is the insertion of an insertion sort algorithm.  The new|
c     real element is inserted into the correct position in a real array which |
c     is sorted in increasing order.                                           |
c                                                                              |
c     Calls:  none                                                             |
c                                                                              |
c     Arguments:                                                               |
c                                                                              |
c     array......Real array.  The sorted list.   {input/output}                |
c     error......Logical.  Indicates if an error has ever occurred during      |
c                   insertion.   {input/output}                                |
c                      error = .true.   =>  an error occurred.                 |
c                      error = .false.  =>  no error.                          |
c     n..........Integer.  Current number of elements in list.   {input/output}|
c     new_elem...Real. New element to be added to array.   {input}             |
c     nmax.......Integer.  Maximum number of elements in array.   {input}      |
c-------------------------------------------------------------------------------
c
      integer nmax,n,k
      real    array(nmax),new_elem
      logical error
c
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
c-----------------------------------------------------------------------
c     Update number of elements in array, initialize pointer.          |
c-----------------------------------------------------------------------
c
      k = n
      n = n + 1
c
      if ((n .gt. 1) .and. (n .le. nmax)) then
c
c-----------------------------------------------------------------------
c        Search for proper location of new element.                    |
c-----------------------------------------------------------------------
c
         do 10 while ((new_elem .lt. array(k)) .and. (k .ge. 2))
            array(k+1) = array(k)
            k = k - 1
 10      continue
c
         if ((k .eq. 1) .and. (new_elem .lt. array(1))) then
            array(2) = array(1)
            k = 0
         end if
c
c-----------------------------------------------------------------------
c        Insert new element in proper location.                        |
c-----------------------------------------------------------------------
c
         array(k+1) = new_elem
         error = error .or. .false.
c
        else if (n .eq. 1) then
c
c-----------------------------------------------------------------------
c        Initialize array.                                             |
c-----------------------------------------------------------------------
c
         array(1) = new_elem
         error = error .or. .false.
c
        else
c
c-----------------------------------------------------------------------
c        Bad array index error.                                        |
c-----------------------------------------------------------------------
c
         error = .true.
c
      end if
c
      return
      end
