      subroutine wrt_bdy (ncid,varname,filename,indx,nx,ny,nxymx,nz,type
     &                                                             ,var)
c
c=======================================================================
c                                                                    ===
c  This routine writes the boundary conditions.                      ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NCID.......NetCDF file identifier.             (integer)       ===
c     VARNAME....Variable name.                      (string)        ===
c     FILENAME...Name of NetCDF file.                (string)        ===
c     INDX.......Index of variable to extract.       (integer)       ===
c     NX.........Number of x gridpoints.             (integer)       ===
c     NY.........Number of y gridpoints.             (integer)       ===
c     NXYMX......Maximum of ( nx , ny )              (integer)       ===
c     NZ.........Number of z gridpoints.             (integer)       ===
c                   (nz<0 flags a 2D field)                          ===
c     TYPE.......Flag and index for type of field.   (integer)       ===
c                  [<0]   barotropic field.                          ===
c                   [0]   scalar                                     ===
c                   [1]   zonal component  (or temp. pe_initial)     ===
c                   [2]   meridional component (or salt. pe_initial) ===
c                   [3]   other tracer  (pe_initial)                 ===
c     VAR........Extracted field variable.   (real array)            ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     LENGTH,  UDIEJOE                                               ===
c                                                                    ===
c     netCDF:  NCVINQ,  NCVPT,  NCVID                                ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <netcdf.inc>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer east,err,indx,ist,n,natt,ncid,nnrm,north,nvdim,nx,nxymx,
     &        ny,nz,sbn,sln,snd,south,type,varid,vartyp,vbn,vln,vnd,west
      integer count(6),start(6),vdims(maxvdims)
      logical canpo,first
      real         var(nz,nxymx,4,3)
      character*80  savnam,wrknam
      character*(*) varname,filename
      character*256 string
c
      parameter (west=1, south=2, east=3, north=4)
c
      save start,count,first,canpo,nnrm,savnam
c
      data nnrm /1/
      data start,count /12*1/
      data canpo,first /.false.,.true./
      data savnam(01:40)/'                                        '/
      data savnam(41:80)/'                                        '/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Get variable identifier.
c-----------------------------------------------------------------------
c
      call length (varname,vln,vbn,vnd)
      varid = ncvid (ncid,varname(vbn:vnd),err)
c
      if (err.ne.0) then
         call length (filename,sln,sbn,snd)
         write (6,10) varname(vbn:vnd),filename(sbn:snd)
         call udiejoe ('WRT_BDY')
      end if
c
c-----------------------------------------------------------------------
c  Determine if output file is "Provided Orlanski" compatible.
c-----------------------------------------------------------------------
c
      wrknam = varname
      if (first .or. (savnam.ne.wrknam)) then
         savnam = wrknam
         first  = .false.
         call ncvinq (ncid,varid,string,vartyp,nvdim,vdims,natt,err)
         if (type.ge.0) then
            canpo = nvdim .gt. 5
         else
            canpo = nvdim .gt. 3
         endif
         if (canpo) then
            nnrm = 3
         else
            nnrm = 1
         end if
      end if
c
c-----------------------------------------------------------------------
c  Write western boundary conditions.
c-----------------------------------------------------------------------
c
      start(1) = type
      count(2) = nz
      count(3) = ny
      if (canpo) then
         start(5) = west
         start(6) = indx
      else
         start(4) = west
         start(5) = indx
      endif
c
      if (type.gt.0) then
         ist = 1
        else if (type.lt.0) then
         ist = 3
        else
         ist = 2
      end if
c
      do n = 1, nnrm
         if (canpo) start(4)=n
         call ncvpt (ncid,varid,start(ist),count(ist),var(1,1,west,n),
     &                                                              err)
c
         if (err.ne.0) then
            call length (filename,sln,sbn,snd)
            write (6,20) varname(vbn:vnd),'west',filename(sbn:snd)
            call udiejoe ('WRT_BDY')
         end if
      enddo
c
c-----------------------------------------------------------------------
c  Write eastern boundary conditions.
c-----------------------------------------------------------------------
c
      if (canpo) then
         start(5) = east
      else
         start(4) = east
      endif
c
      do n = 1, nnrm
         if (canpo) start(4)=n
         call ncvpt (ncid,varid,start(ist),count(ist),var(1,1,east,n),
     &                                                              err)
c
         if (err.ne.0) then
            call length (filename,sln,sbn,snd)
            write (6,20) varname(vbn:vnd),'east',filename(sbn:snd)
            call udiejoe ('WRT_BDY')
         end if
      enddo
c
c-----------------------------------------------------------------------
c  Write southern boundary conditions.
c-----------------------------------------------------------------------
c
      count(3) = nx
      if (canpo) then
         start(5) = south
      else
         start(4) = south
      endif
c
      do n = 1, nnrm
         if (canpo) start(4)=n
         call ncvpt (ncid,varid,start(ist),count(ist),var(1,1,south,n),
     &                                                              err)
c
         if (err.ne.0) then
            call length (filename,sln,sbn,snd)
            write (6,20) varname(vbn:vnd),'south',filename(sbn:snd)
            call udiejoe ('WRT_BDY')
         end if
      enddo
c
c-----------------------------------------------------------------------
c  Write northern boundary conditions.
c-----------------------------------------------------------------------
c
      if (canpo) then
         start(5) = north
      else
         start(4) = north
      endif
c
      do n = 1, nnrm
         if (canpo) start(4)=n
         call ncvpt (ncid,varid,start(ist),count(ist),var(1,1,north,n),
     &                                                              err)
c
         if (err.ne.0) then
            call length (filename,sln,sbn,snd)
            write (6,20) varname(vbn:vnd),'north',filename(sbn:snd)
            call udiejoe ('WRT_BDY')
         end if
      enddo
c
      return
c
 10   format (/'*** Error:  WRT_FLD - unable to find variable ',
     &                              1h",a,1h",' in file:'/12x,1h",a,1h")
 20   format (/'*** Error:  WRT_FLD - unable to write variable ',
     &        1h",a,1h",' along ',a,'ern boundary to file:'/12x,
     &        1h",a,1h")
c
      end
