      subroutine all_uc (instrng,outstrng)
c
c=======================================================================
c                                                                    ===
c  This routine copies as much text as it can from the input string  ===
c  to the output string, converting lowercase letters to uppercase.  ===
c                                                                    ===
c  Warning:  The output string is pre-filled with blanks.  It MUST   ===
c            be a different variable than the input string.          ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     instrng....Input character string.                             ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     outstrng...Output character string.                            ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer       chrcode,n,nstop
      character*(*) instrng,outstrng
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Pre-fill output string with blanks. (FORTRAN-77 will pad with blanks)
c-----------------------------------------------------------------------
c
      outstrng = ' '
c
c-----------------------------------------------------------------------
c  Determine amount of data to transfer.
c-----------------------------------------------------------------------
c
      nstop = min( len(instrng), len(outstrng) )
c
c-----------------------------------------------------------------------
c  Transfer the data, converting lower case letters to upper case.
c-----------------------------------------------------------------------
c
      do 10 n = 1, nstop
         chrcode = ichar(instrng(n:n))
         if ( (chrcode.lt.97) .or. (chrcode.gt.122) ) then
            outstrng(n:n) = instrng(n:n)
           else
            outstrng(n:n) = char(chrcode-32)
         end if
 10   continue
c
      return
      end
