      subroutine get_dxy (ncid,filename,nx,ny,xymrat,yxmrat)
c
c=======================================================================
c                                                                    ===
c  This routine reads the necessary data to construct derivatives.   ===
c  Currently only valid for cartesian grids.                         ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NCID.......NetCDF file identifier.             (integer)       ===
c     FILENAME...Name of NetCDF file.                (string)        ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     XYMRAT...XoverY metric ratio (w/ hv & dy).   (real array)      ===
c     YXMRAT...YoverX metric ratio (w/ hv & dx).   (real array)      ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     GET_SCLR,  LENGTH,  UDIEJOE                                    ===
c                                                                    ===
c     netCDF:  NCAINQ                                                ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <netcdf.inc>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer attype,atlen,err,fbn,fln,fnd,i,j,ncid,nx,ny
      logical isnew
      real    c1,dx,dy,m2cm,p25,p5
      real    xymrat(nx,ny),yxmrat(nx,ny)
      character*(*) filename
      parameter (c1=1.0, m2cm=100.0, p25=0.25, p5=0.5)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Determine length of PE file name.
c-----------------------------------------------------------------------
c
      call length (filename,fln,fbn,fnd)
c
c-----------------------------------------------------------------------
c  Determine vintage of PE file.
c-----------------------------------------------------------------------
c
      call ncainq (ncid,ncglobal,'version',attype,atlen,err)
c
      if (err.ne.0) then
         write (6,900) 'GLOBAL:version',filename(fbn:fnd)
         call udiejoe ('GET_DXY')
      end if
c
      isnew = attype .eq. ncchar
c
c-----------------------------------------------------------------------
c  Read spacing/metric data.
c-----------------------------------------------------------------------
c
      if (isnew) then
c
c     Read spacings from modern HOPS PE netCDF file.
c
         call get_sclr (ncid,'dxt',filename,1,dx)
         call get_sclr (ncid,'dyt',filename,1,dy)
c
       else
c
c     Read spacings from old (v7.27 & earlier) HOPS PE netCDF file.
c
         call get_sclr (ncid,'gridx',filename,1,dx)
         call get_sclr (ncid,'gridy',filename,1,dy)
c
      end if
c
c-----------------------------------------------------------------------
c  Get topography at velocity points.
c-----------------------------------------------------------------------
c
c  Read topography at tracer points.
c
      call get_fld (ncid,'tbath',filename,1,nx,ny,1,-1,yxmrat)
c
c  Compute topography at velocity points.
c
      do 20 j = 1, (ny-1)
         do 10 i = 1, (nx-1)
            xymrat(i,j) = p25*(yxmrat(i,j)  +yxmrat(i+1,j)+
     &                         yxmrat(i,j+1)+yxmrat(i+1,j+1))*m2cm
  10     continue
         xymrat(nx,j) = p5*(yxmrat(nx,j)+yxmrat(nx,j+1))*m2cm
  20  continue
c
      do 30 i = 1, (nx-1)
         xymrat(i,ny) = p5*(yxmrat(i,ny)+yxmrat(i+1,ny))*m2cm
  30  continue
      xymrat(nx,ny) = p5*(xymrat(nx,ny-1)+xymrat(nx-1,ny))
c
c-----------------------------------------------------------------------
c  Load metric ratios.
c-----------------------------------------------------------------------
c
c  Start with the inverse of the topographic depth.
c
      do 40 j = 1, ny
      do 40 i = 1, nx
         yxmrat(i,j) = c1/xymrat(i,j)
         xymrat(i,j) = yxmrat(i,j)
  40  continue
c
c  Apply appropriate grid spacing (assumed constant).
c
      do 50 j = 1, ny
      do 50 i = 1, nx
         yxmrat(i,j) = yxmrat(i,j)/(dx*dx)
         xymrat(i,j) = xymrat(i,j)/(dy*dy)
  50  continue
c
      return
c
 900  format (/'*** Error:  GET_DXY - unable to inquire about attribute'
     &                           1x,1h",a,1h",' in file:'/12x,1h",a,1h")
 910  format (/'*** Error:  GET_DXY - unable to find variable ',
     &                              1h",a,1h",' in file:'/12x,1h",a,1h")
 920  format (/'*** Error:  GET_DXY - unable to read variable ',
     &                              1h",a,1h",' in file:'/12x,1h",a,1h")
c
      end
