      subroutine get_mask (ncid,varname,filename,nx,ny,var,found)
c
c-----------------------------------------------------------------------
c     This routine gets a field variable from the given netCDF file.   |
c                                                                      |
c            Calls:  udiejoe                                           |
c     netCDF Calls:  ncvgt, ncvid                                      |
c                                                                      |
c     Input:                                                           |
c                                                                      |
c        ncid.......Integer.  NetCDF file identifier.                  |
c        varname....Character.  Variable name.                         |
c        filename...Character.  Name of NetCDF file.                   |
c        nx.........Integer.  Number of x gridpoints.                  |
c        ny.........Integer.  Number of y gridpoints.                  |
c                                                                      |
c     Output                                                           |
c                                                                      |
c        var........Real.  Extracted field variable.                   |
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c     Global data.                                                     |
c-----------------------------------------------------------------------
c
#include <netcdf.inc>
c
c-----------------------------------------------------------------------
c     Local data.                                                      |
c-----------------------------------------------------------------------
c
      integer err,ncid,nx,ny,varid
      integer count(2),start(2)
      logical found
      real          var(nx,ny)
      character*(*) varname,filename
c
      save start,count
c
      data start,count /4*1/
c
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
c-----------------------------------------------------------------------
c     Get variable identifier.                                         |
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,varname,err)
c
      found = err .eq. 0
c
c-----------------------------------------------------------------------
c     Read variable.                                                   |
c-----------------------------------------------------------------------
c
      if (found) then
c
         count(1) = nx
         count(2) = ny
c
         call ncvgt (ncid,varid,start,count,var,err)
c
         if (err.ne.0) then
            write (6,10) varname,filename
            call udiejoe ('GET_MASK')
         end if
c
      end if
c
      return
c
 10   format (/'*** Error:  GET_MASK - unable to read variable ',
     &                              1h",a,1h",' in file:'/12x,1h",a,1h")
c
      end
