      subroutine getnedim (ncid,dimname,filename,dim,fnd)
c
c-----------------------------------------------------------------------
c     This routine gets the dimension size from the supplied netCDF    |
c     file.  This version does NOT cause an error if the particular    |
c     dimension is not found.                                          |
c                                                                      |
c            Calls:  udiejoe                                           |
c     netCDF Calls:  ncdid, ncdinq                                     |
c                                                                      |
c     Input:                                                           |
c                                                                      |
c        ncid.......Integer.  NetCDF file identifier.                  |
c        dimname....Character.  Name of requested dimension.           |
c        filename...Character.  Name of NetCDF file (for error msgs.)  |
c                                                                      |
c     Output:                                                          |
c                                                                      |
c        dim........Integer.  The size of the dimension.               |
c        fnd........Logical.  Exit status.                             |
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c     Global data.                                                     |
c-----------------------------------------------------------------------
c
#include <netcdf.inc>
c
c-----------------------------------------------------------------------
c     Local data.                                                      |
c-----------------------------------------------------------------------
c
      integer dim,dimid,err,ncid
      logical fnd
      character*80 dummy
      character*(*) dimname,filename
c
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
c-----------------------------------------------------------------------
c     Get dimension identifier for netCDF file.                        |
c-----------------------------------------------------------------------
c
      dimid = ncdid (ncid,dimname,err)
c
      fnd = err .eq. 0
c
      if (.not.fnd) return
c
c-----------------------------------------------------------------------
c     Get dimension size from netCDF file.                             |
c-----------------------------------------------------------------------
c
      call ncdinq (ncid,dimid,dummy,dim,err)
c
      if (err.ne.0) then
         write (6,10) dimname,filename
         call udiejoe ('GETNEDIM')
      end if
c
      return
c
 10   format (/'*** Error:  GETNEDIM - unable to read dimension ',1h",a,
     &                                    1h",' in file:'/12x,1h",a,1h")
c
      end
