      subroutine scalvclin (nx,ny,nz,vin,dz,vout,command)
c
c-----------------------------------------------------------------------
c     This routine computes the box thicknesses from the mid-level     |
c     depths.                                                          |
c                                                                      |
c     Calls:  none                                                     |
c                                                                      |
c     Input:                                                           |
c                                                                      |
c        nx........The number of x-grid points.                        |
c        ny........The number of y-grid points.                        |
c        nz........The number of model levels.                         |
c        vin.......The velocity component to be scaled.                |
c        dz........The box thicknesses.                                |
c        command...Instruction on which action to take.                |
c                                                                      |
c     Output:                                                          |
c                                                                      |
c        vout.......The scaled velocity component.                     |
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c     Local data.                                                      |
c-----------------------------------------------------------------------
c
      integer i,j,k,nx,ny,nz
      real hsum,vavg,dz(nz,nx,ny),vin(nz,nx,ny),vout(nz,nx,ny)
      character*(*) command
c
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
c-----------------------------------------------------------------------
c     Compute box thicknesses.                                         |
c-----------------------------------------------------------------------
c
      if (command.eq.'Multiply') then
c
         do 10 j = 1, ny
         do 10 i = 1, nx
         do 10 k = 1, nz
            vout(k,i,j) = vin(k,i,j)*dz(k,i,j)
 10      continue
c
       else
c
         do 20 j = 1, ny
         do 20 i = 1, nx
         do 20 k = 1, nz
            vout(k,i,j) = vin(k,i,j)/dz(k,i,j)
 20      continue
c
c      Now make sure final result is baroclinic.
c      (could be ruined by extension under a mask)
c
         do 40 j = 1, ny
         do 40 i = 1, nx
            hsum = dz(1,i,j)
            vavg = dz(1,i,j)*vout(1,i,j)
            do 30 k = 2, nz
               hsum = hsum + dz(k,i,j)
               vavg = vavg + dz(k,i,j)*vout(k,i,j)
 30         continue
            vavg = vavg/hsum
            do 40 k = 1, nz
               vout(k,i,j) = vout(k,i,j) - vavg
 40      continue
c
      end if
c
      return
      end
