% HOPS PE Skill Metrics Box
%
% The scripts in this directory compute the RMS error and Pattern
% Correlation Coefficient for a HOPS PE run.   A HOPS PE_initial
% assimilation file is required for a reference.
%
% -------
% Drivers
% -------
%
%    pe_rmse...Drives the computation of the RMS errors.  Records the
%              results in a user-specified ASCII file.  Also saves the
%              results and the difference fields in a user-specified
%              MATLAB file.
%    pe_pcc....Drives the computation of the PCC.  Records the
%              results in a user-specified ASCII file.  Also saves the
%              results and the anomaly fields in a user-specified
%              MATLAB file.
%
%    stats_view.......Makes plots of RMS errors and PCC by time.
%                     Individual curves for each depth.
%    stats_lev_view...Makes plots of RMS errors and PCC by depth.
%                     Individual curves for each time.
%    skill_dist.......Makes plots of difference and anomaly fields
%                     for the requested fields at the requested times
%                     and depths.
%
% ---------------------------------
% Intermediate Computation Routines
% ---------------------------------
%
%    pcc_pe....Organizes individual PCC computations.
%    pbr_pcc...Computes PCC for transport streamfunction.
%    trc_pcc...Computes PCC for tracers.
%    vel_pcc...Computes PCC for velocity.
%
%    rms_pe....Organizes individual RMS computations.
%    pbr_rms...Computes RMS for transport streamfunction.
%    trc_rms...Computes RMS for tracers.
%    vel_rms...Computes RMS for velocity.
%
% ------------------------------
% Intermediate Plotting Routines
% ------------------------------
%
%    statplt........Creates an individual difference or anomaly plot.
%    add_cst........Adds GSHHS coastlines to a plot.
%    plot_cst.......Draws a selected subset of coasts from the GSHHS coast set. 
%    colorbarclvl...Produces uniform color bars for difference plots.
%                   Also used for anomaly plots.
%
% -------------------------
% Intermediate I/O Routines
% -------------------------
%
%    pe_rmse_parm......Reads the run parmeters for PE_RMSE and PE_PCC
%    stats_view_parm...Reads the run parmeters for STATS_VIEW and STATS_LEV_VIEW
%    skill_dist_parm...Reads the run parmeters for SKILL_DIST
%    num_read..........Reads a single numerical value from an input file.
