% pe_pcc
%
% This script computes the Pattern Correlation Coefficient.

%-------------------------------------------------------------------------------
% Get name of input file containing run parameters.
%-------------------------------------------------------------------------------

parmfiledef = 'pe_pcc.in';

parmfile = input (['Enter name of parameter input file [',parmfiledef, ...
                   ']: '],'s');
if isempty(parmfile)
   parmfile = parmfiledef;
end;

clear parmfiledef;

%-------------------------------------------------------------------------------
% Read run parameters.
%-------------------------------------------------------------------------------

[errtol,petims,pitims,lonlim,latlim,zlev,fldnam,pefile,pifile, ...
                               outfil,outmat,status] = pe_rmse_parm (parmfile);

%-------------------------------------------------------------------------------
% Open files.
%-------------------------------------------------------------------------------

status = mexcdf ('setopts',0);

%---------------------
%--- Open PE file. ---
%---------------------

ncpe = netcdf(pefile);

if isempty(ncpe)
   disp (' ');
   disp ('***Error:  PE_PCC - unable to open PE netCDF file:');
   disp (['           ',setstr(34),pefile,setstr(34)]);
   disp (' ');
   return
end

%-----------------------------
%--- Open PE_initial file. ---
%-----------------------------

ncpi = netcdf(pifile);

if isempty(ncpi)
   disp (' ');
   disp ('***Error:  PE_PCC - unable to open PE_initial netCDF file:');
   disp (['           ',setstr(34),pifile,setstr(34)]);
   disp (' ');
   return
end

%--------------------------
%--- Open results file. ---
%--------------------------

[outid,mess] = fopen (outfil,'w');

if (outid<0)
   disp (' ');
   disp ('***Error:  PE_PCC - unable to open output results file:');
   disp (['           ',setstr(34),outfil,setstr(34)]);
   disp (['           ',setstr(34),mess,setstr(34)]);
   status = fid;
   return;
end;

count = fprintf (outid,'\nPattern Correlation Coefficients:\n   %s\n', ...
                deblank(pefile));
count = fprintf (outid,'   %s\n\n',deblank(pifile));
count = fprintf (outid,['  Analyses limited to:\n      Error field <= %f\n', ...
                       '      Longitudes in the range [%f, %f]\n', ...
                       '       Latitudes in the range [%f, %f]\n\n'], ...
                       [errtol lonlim latlim]);

%-------------------------------------------------------------------------------
% Compute & report PCC
%-------------------------------------------------------------------------------

pcc_pe (errtol,petims,pitims,lonlim,latlim,zlev,fldnam,ncpe,ncpi,outid,outmat);

%-------------------------------------------------------------------------------
% Close files.
%-------------------------------------------------------------------------------

%---------------------
%--- Close PE file. ---
%---------------------

status = close(ncpe);

if ~isempty(status)
   disp (' ');
   disp ('***Error:  PE_PCC - unable to close PE netCDF file:');
   disp (['           ',setstr(34),pefile,setstr(34)]);
   disp (' ');
   return
end

%-----------------------------
%--- Close PE_initial file. ---
%-----------------------------

status = close(ncpi);

if ~isempty(status)
   disp (' ');
   disp ('***Error:  PE_PCC - unable to open PE_initial netCDF file:');
   disp (['           ',setstr(34),pifile,setstr(34)]);
   disp (' ');
   return
end

%--------------------------
%--- Open results file. ---
%--------------------------

status = fclose (outid);

if (status<0)
   disp (' ');
   disp ('***Error:  PE_PCC - unable to close output results file:');
   disp (['           ',setstr(34),outfil,setstr(34)]);
end;
