% skill_dist
%
% This script creates distribution results from the RMS error & PCC calc.s.

%-------------------------------------------------------------------------------
% Get name of input file containing run parameters.
%-------------------------------------------------------------------------------

parmfiledef = 'skill_dist.in';

parmfile = input (['Enter name of parameter input file [',parmfiledef, ...
                   ']: '],'s');
if isempty(parmfile)
   parmfile = parmfiledef;
end;

clear parmfiledef;

%-------------------------------------------------------------------------------
% Read run parameters.
%-------------------------------------------------------------------------------

[zplot,pltnd,lnlm,ltlm,fldnam,cst_file,persrms, ...
                   perspcc,simrms,simpcc,status] = skill_dist_parm (parmfile);

%-------------------------------------------------------------------------------
% Get data.
%-------------------------------------------------------------------------------

%------------------------------
%--- Load persistence data. ---
%------------------------------

eval(['load ',persrms]);
eval(['load ',perspcc]);

%----------------------------------
%--- Preserve persistence data. ---
%----------------------------------

[nfld mxchr] = size(fldnam);

for vind = 1:nfld;

   difnam = [deblank(fldnam(vind,:)),'fdiff'];
   peanam = [deblank(fldnam(vind,:)),'peana'];

   eval ([difnam,'P = ',difnam,';']);
   eval ([peanam,'P = ',peanam,';']);

end;

%---------------------------
%--- Load forecast data. ---
%---------------------------

eval(['load ',simrms]);
eval(['load ',simpcc]);

%-------------------------------------------------------------------------------
% Compute & report RMS errors
%-------------------------------------------------------------------------------

dz = abs(zlev-zplot);
zind = min(find(dz==min(dz(:))));

for tind = 1:length(pltnd);
for vind = 1:nfld;

   difnam = [deblank(fldnam(vind,:)),'fdiff'];
   peanam = [deblank(fldnam(vind,:)),'peana'];
   pianam = [deblank(fldnam(vind,:)),'piana'];

   eval(['clvl = nice(extrem([', ...
                     'extrem(squeeze(',difnam,'(pltnd(tind),:,:,zind))) ', ...
                  'extrem(squeeze(',difnam,'P(pltnd(tind),:,:,zind)))]),4);']);

   clf;
   eval(['statplt (tlon,tlat,squeeze(',difnam, ...
                   '(pltnd(tind),:,:,zind)),lnlm,ltlm,cst_file,clvl);']);
   eval(['print -depsc ',difnam,num2str(pltnd(tind)),'.eps']);
   eval(['print -dppm ',difnam,num2str(pltnd(tind)),'.ppm']);

   clf;
   eval(['statplt (tlon,tlat,squeeze(',difnam, ...
                   'P(pltnd(tind),:,:,zind)),lnlm,ltlm,cst_file,clvl);']);
   eval(['print -depsc ',difnam,'P',num2str(pltnd(tind)),'.eps']);
   eval(['print -dppm ',difnam,'P',num2str(pltnd(tind)),'.ppm']);

   eval(['clvl = nice(extrem([', ...
                      'extrem(squeeze(',peanam,'(pltnd(tind),:,:,zind))) ', ...
                     'extrem(squeeze(',peanam,'P(pltnd(tind),:,:,zind))) ', ...
                   'extrem(squeeze(',pianam,'(pltnd(tind),:,:,zind)))]),4);']);

   clf;
   eval(['statplt (tlon,tlat,squeeze(',peanam, ...
                   '(pltnd(tind),:,:,zind)),lnlm,ltlm,cst_file,clvl);']);
   eval(['print -depsc ',peanam,num2str(pltnd(tind)),'.eps']);
   eval(['print -dppm ',peanam,num2str(pltnd(tind)),'.ppm']);

   clf;
   eval(['statplt (tlon,tlat,squeeze(',peanam, ...
                   'P(pltnd(tind),:,:,zind)),lnlm,ltlm,cst_file,clvl);']);
   eval(['print -depsc ',peanam,'P',num2str(pltnd(tind)),'.eps']);
   eval(['print -dppm ',peanam,'P',num2str(pltnd(tind)),'.ppm']);

   clf;
   eval(['statplt (tlon,tlat,squeeze(',pianam, ...
                   '(pltnd(tind),:,:,zind)),lnlm,ltlm,cst_file,clvl);']);
   eval(['print -depsc ',pianam,num2str(pltnd(tind)),'.eps']);
   eval(['print -dppm ',pianam,num2str(pltnd(tind)),'.ppm']);

end;
end;
