% stats_view
%
% This script creates plots the RMS error & Pattern Correlation Coefficients.

%-------------------------------------------------------------------------------
% Get name of input file containing run parameters.
%-------------------------------------------------------------------------------

parmfiledef = 'stats_lev_view.in';

parmfile = input (['Enter name of parameter input file [',parmfiledef, ...
                   ']: '],'s');
if isempty(parmfile)
   parmfile = parmfiledef;
end;

clear parmfiledef;

%-------------------------------------------------------------------------------
% Read run parameters.
%-------------------------------------------------------------------------------

[fldnam,fldlbl,fldunt,rmsp_file, ...
 pccp_file,rms_file,pcc_file,status] = stats_view_parm (parmfile);

%-------------------------------------------------------------------------------
% Get persistence data.
%-------------------------------------------------------------------------------

eval(['load ',rmsp_file]);
eval(['load ',pccp_file]);

[nfld mxchr] = size(fldnam);

for vind = 1:nfld;
   basename = deblank(fldnam(vind,:));
   eval([basename,'rmsp = ',basename,'rms;']);
   eval([basename,'pccp = ',basename,'pcc;']);
end;

tpep  = tpe;
tpip  = tpi;
zlevp = zlev;

clear rmsp_file pccp_file

%-------------------------------------------------------------------------------
% Get simulation data.
%-------------------------------------------------------------------------------

eval(['load ',rms_file]);
eval(['load ',pcc_file]);

clear rms_file pcc_file

%-------------------------------------------------------------------------------
% Plot statistics
%-------------------------------------------------------------------------------

%--------------------------------
%--- Prepare level variables. ---
%--------------------------------

nlev = length(zlev) + 1;
ntim = length(tpe);

levind = 1:nlev;

levplt = levind'*ones(1,ntim);

%-----------------------------
%--- Prepare legend label. ---
%-----------------------------

if (ntim>1)
   lbl01 = [num2str(tpe') setstr(ones(ntim,1)*abs(' (days)'))];
   leglbl = strvcat(lbl01,'Simulation (solid)','Persistence (dashed)');
   clear lbl01;
 else
%   leglbl = strvcat('Simulation (solid)','Persistence (dashed)');
   leglbl = strvcat('Simulation','Persistence');
   ttl = pjh_greg(tpi);
end;

%-----------------------------
%--- Prepare y-axis label. ---
%-----------------------------

lbl01 = [num2str(zlev') setstr(ones(nlev-1,1)*abs(' (m)'))];
ylbl = strvcat(lbl01,'Mean');
clear lbl01;

%-----------------------
%--- Set text sizes. ---
%-----------------------

bassize = 14;
legsize = bassize/sqrt(2);

%-------------------
%--- Make plots. ---
%-------------------

[nfld mxchr] = size(fldnam);

for vind = 1:nfld;

   basename = deblank(fldnam(vind,:));
   eval(['ncomp = length(size(',basename,'rms));']);

   if (ncomp==2)
      figure;
      eval(['hsim = plot(',basename,'rms',setstr(39),',levplt);']);
      hold on;
      eval(['hper = plot(',basename,'rmsp',setstr(39),',levplt,' ...
             ,setstr(39),'--',setstr(39),');']);
      set (hsim,'Marker','*');
      set (hper,'Marker','o');
      set(gca,'FontName','Times','FontSize',bassize, ...
              'YTick',levind,'YTickLabel',ylbl,'YDir','Reverse');
      grid on;
      xlim = get (gca,'XLim');
      hdum = plot (xlim,[NaN NaN],'w',xlim,[NaN NaN],'w--');
      if (ntim>1)
%         [legh objh outh outm] = legend ([hsim; hsim(1); hper(1)],leglbl);
         [legh objh outh outm] = legend ([hsim; hdum],leglbl);
       else
         [legh objh outh outm] = legend ([hsim(1); hper(1)],leglbl);
%         [legh objh outh outm] = legend ([hdum],leglbl);
      end;
      set (objh(1),'FontSize',legsize);
      xlabel(['RMS error (',deblank(fldunt(vind,:)),')']);
      if (ntim>1)
         title(deblank(fldlbl(vind,:)));
       else
         title([deblank(fldlbl(vind,:)),'  ',ttl]);
      end;

      figure;
      eval(['hsim = plot(',basename,'pcc',setstr(39),',levplt);']);
      hold on;
      eval(['hper = plot(',basename,'pccp',setstr(39),',levplt,', ...
             setstr(39),'--',setstr(39),');']);
      set (hsim,'Marker','*');
      set (hper,'Marker','o');
      set(gca,'FontName','Times','FontSize',bassize, ...
              'YTick',levind,'YTickLabel',ylbl,'YDir','Reverse');
      grid on;
      xlim = get (gca,'XLim');
      hdum = plot (xlim,[NaN NaN],'w',xlim,[NaN NaN],'w--');
      if (ntim>1)
%         [legh objh outh outm] = legend ([hsim; hsim(1); hper(1)],leglbl);
         [legh objh outh outm] = legend ([hsim; hdum],leglbl);
       else
         [legh objh outh outm] = legend ([hsim(1); hper(1)],leglbl);
%         [legh objh outh outm] = legend ([hdum],leglbl);
      end;
      set (objh(1),'FontSize',legsize);
      xlabel('Pattern Correlation Coefficient');
      if (ntim>1)
         title(deblank(fldlbl(vind,:)));
       else
         title([deblank(fldlbl(vind,:)),'  ',ttl]);
      end;
   else
      figure;
      eval(['hsim = plot(squeeze(',basename,'rms(:,1,:))',setstr(39), ...
            ',levplt);']);
      hold on;
      eval(['hper = plot(squeeze(',basename,'rmsp(:,1,:))',setstr(39), ...
             ',levplt,',setstr(39),'--',setstr(39),');']);
      set (hsim,'Marker','*');
      set (hper,'Marker','o');
      set(gca,'FontName','Times','FontSize',bassize, ...
              'YTick',levind,'YTickLabel',ylbl,'YDir','Reverse');
      grid on;
      xlim = get (gca,'XLim');
      hdum = plot (xlim,[NaN NaN],'w',xlim,[NaN NaN],'w--');
      if (ntim>1)
%         [legh objh outh outm] = legend ([hsim; hsim(1); hper(1)],leglbl);
         [legh objh outh outm] = legend ([hsim; hdum],leglbl);
       else
         [legh objh outh outm] = legend ([hsim(1); hper(1)],leglbl);
%         [legh objh outh outm] = legend ([hdum],leglbl);
      end;
      set (objh(1),'FontSize',legsize);
      xlabel(['RMS error (',deblank(fldunt(vind,:)),')']);
      if (ntim>1)
         title(deblank(fldlbl(vind,:)));
       else
         title([deblank(fldlbl(vind,:)),'  ',ttl]);
      end;

      figure;
      eval(['hsim = plot(squeeze(',basename,'rms(:,2,:))',setstr(39), ...
            ',levplt);']);
      hold on;
      eval(['hper = plot(squeeze(',basename,'rmsp(:,2,:))',setstr(39), ...
             ',levplt,',setstr(39),'--',setstr(39),');']);
      set (hsim,'Marker','*');
      set (hper,'Marker','o');
      set(gca,'FontName','Times','FontSize',bassize, ...
              'YTick',levind,'YTickLabel',ylbl,'YDir','Reverse');
      grid on;
      xlim = get (gca,'XLim');
      hdum = plot (xlim,[NaN NaN],'w',xlim,[NaN NaN],'w--');
      if (ntim>1)
%         [legh objh outh outm] = legend ([hsim; hsim(1); hper(1)],leglbl);
         [legh objh outh outm] = legend ([hsim; hdum],leglbl);
       else
         [legh objh outh outm] = legend ([hsim(1); hper(1)],leglbl);
%         [legh objh outh outm] = legend ([hdum],leglbl);
      end;
      set (objh(1),'FontSize',legsize);
      xlabel(['RMS error (',deblank(fldunt(vind,:)),')']);
      if (ntim>1)
         title(deblank(fldlbl(vind,:)));
       else
         title([deblank(fldlbl(vind,:)),'  ',ttl]);
      end;

      figure;
      eval(['hsim = plot(squeeze(',basename,'pcc(:,1,:))',setstr(39), ...
            ',levplt);']);
      hold on;
      eval(['hper = plot(squeeze(',basename,'pccp(:,1,:))',setstr(39), ...
            ',levplt,',setstr(39),'--',setstr(39),');']);
      set (hsim,'Marker','*');
      set (hper,'Marker','o');
      set(gca,'FontName','Times','FontSize',bassize, ...
              'YTick',levind,'YTickLabel',ylbl,'YDir','Reverse');
      grid on;
      xlim = get (gca,'XLim');
      hdum = plot (xlim,[NaN NaN],'w',xlim,[NaN NaN],'w--');
      if (ntim>1)
%         [legh objh outh outm] = legend ([hsim; hsim(1); hper(1)],leglbl);
         [legh objh outh outm] = legend ([hsim; hdum],leglbl);
       else
         [legh objh outh outm] = legend ([hsim(1); hper(1)],leglbl);
%         [legh objh outh outm] = legend ([hdum],leglbl);
      end;
      set (objh(1),'FontSize',legsize);
      xlabel('Pattern Correlation Coefficient');
      if (ntim>1)
         title(deblank(fldlbl(vind,:)));
       else
         title([deblank(fldlbl(vind,:)),'  ',ttl]);
      end;

      figure;
      eval(['hsim = plot(squeeze(',basename,'pcc(:,2,:))',setstr(39), ...
            ',levplt);']);
      hold on;
      eval(['hper = plot(squeeze(',basename,'pccp(:,2,:))',setstr(39), ...
            ',levplt,',setstr(39),'--',setstr(39),');']);
      set (hsim,'Marker','*');
      set (hper,'Marker','o');
      set(gca,'FontName','Times','FontSize',bassize, ...
              'YTick',levind,'YTickLabel',ylbl,'YDir','Reverse');
      grid on;
      xlim = get (gca,'XLim');
      hdum = plot (xlim,[NaN NaN],'w',xlim,[NaN NaN],'w--');
      if (ntim>1)
%         [legh objh outh outm] = legend ([hsim; hsim(1); hper(1)],leglbl);
         [legh objh outh outm] = legend ([hsim; hdum],leglbl);
       else
         [legh objh outh outm] = legend ([hsim(1); hper(1)],leglbl);
%         [legh objh outh outm] = legend ([hdum],leglbl);
      end;
      set (objh(1),'FontSize',legsize);
      xlabel('Pattern Correlation Coefficient');
      if (ntim>1)
         title(deblank(fldlbl(vind,:)));
       else
         title([deblank(fldlbl(vind,:)),'  ',ttl]);
      end;
   end;

end;
