% stats_view
%
% This script creates plots the RMS error & Pattern Correlation Coefficients.

%-------------------------------------------------------------------------------
% Get name of input file containing run parameters.
%-------------------------------------------------------------------------------

parmfiledef = 'stats_view.in';

parmfile = input (['Enter name of parameter input file [',parmfiledef, ...
                   ']: '],'s');
if isempty(parmfile)
   parmfile = parmfiledef;
end;

clear parmfiledef;

%-------------------------------------------------------------------------------
% Read run parameters.
%-------------------------------------------------------------------------------

[fldnam,fldlbl,fldunt,rmsp_file, ...
 pccp_file,rms_file,pcc_file,status] = stats_view_parm (parmfile);

%-------------------------------------------------------------------------------
% Get persistence data.
%-------------------------------------------------------------------------------

eval(['load ',rmsp_file]);
eval(['load ',pccp_file]);

[nfld mxchr] = size(fldnam);

for vind = 1:nfld;
   basename = deblank(fldnam(vind,:));
   eval([basename,'rmsp = ',basename,'rms;']);
   eval([basename,'pccp = ',basename,'pcc;']);
end;

tpep  = tpe;
tpip  = tpe;
zlevp = zlev;

clear rmsp_file pccp_file

%-------------------------------------------------------------------------------
% Get simulation data.
%-------------------------------------------------------------------------------

eval(['load ',rms_file]);
eval(['load ',pcc_file]);

clear rms_file pcc_file

%-------------------------------------------------------------------------------
% Plot statistics
%-------------------------------------------------------------------------------

%-------------------------------
%--- Prepare time variables. ---
%-------------------------------

nlev = length(zlev) + 1;

tpe2  = tpe'*ones(1,nlev);
tpep2 = tpep'*ones(1,nlev);

%-----------------------------
%--- Prepare legend label. ---
%-----------------------------

nlev = nlev - 1;
lbl01 = [num2str(zlev') setstr(ones(nlev,1)*abs(' (m)'))];
leglbl = strvcat(lbl01,'Mean','Simulation (solid)','Persistence (dashed)');
clear lbl01;

%-----------------------
%--- Set text sizes. ---
%-----------------------

bassize = 14;
legsize = bassize/sqrt(2);

%-------------------
%--- Make plots. ---
%-------------------

[nfld mxchr] = size(fldnam);

for vind = 1:nfld;

   basename = deblank(fldnam(vind,:));
   eval(['ncomp = length(size(',basename,'rms));']);

   if (ncomp==2)
      figure;
      eval(['hsim = plot(tpe2,',basename,'rms);']);
      hold on;
      eval(['hper = plot(tpe2,',basename,'rmsp,',setstr(39),'--', ...
             setstr(39),');']);
      set(gca,'FontName','Times','FontSize',bassize);
      grid on;
      xlim = get (gca,'XLim');
      hdum = plot (xlim,[NaN NaN],'w',xlim,[NaN NaN],'w--');
%      [legh objh outh outm] = legend ([hsim; hsim(1); hper(1)],leglbl);
      [legh objh outh outm] = legend ([hsim; hdum],leglbl);
      set (objh(1),'FontSize',legsize);
      xlabel('Time  (days)');
      ylabel(['RMS error (',deblank(fldunt(vind,:)),')']);
      title(deblank(fldlbl(vind,:)));

      figure;
      eval(['hsim = plot(tpe2,',basename,'pcc);']);
      hold on;
      eval(['hper = plot(tpe2,',basename,'pccp,',setstr(39),'--', ...
             setstr(39),');']);
      set(gca,'FontName','Times','FontSize',bassize);
      grid on;
      xlim = get (gca,'XLim');
      hdum = plot (xlim,[NaN NaN],'w',xlim,[NaN NaN],'w--');
%      [legh objh outh outm] = legend ([hsim; hsim(1); hper(1)],leglbl);
      [legh objh outh outm] = legend ([hsim; hdum],leglbl);
      set (objh(1),'FontSize',legsize);
      xlabel('Time  (days)');
      ylabel('Pattern Correlation Coefficient');
      title(deblank(fldlbl(vind,:)));
   else
      figure;
      eval(['hsim = plot(tpe2,squeeze(',basename,'rms(:,1,:)));']);
      hold on;
      eval(['hper = plot(tpe2,squeeze(',basename,'rmsp(:,1,:)),', ...
             setstr(39),'--',setstr(39),');']);
      set(gca,'FontName','Times','FontSize',bassize);
      grid on;
      xlim = get (gca,'XLim');
      hdum = plot (xlim,[NaN NaN],'w',xlim,[NaN NaN],'w--');
%      [legh objh outh outm] = legend ([hsim; hsim(1); hper(1)],leglbl);
      [legh objh outh outm] = legend ([hsim; hdum],leglbl);
      set (objh(1),'FontSize',legsize);
      xlabel('Time  (days)');
      ylabel(['RMS error (',deblank(fldunt(vind,:)),')']);
      title([deblank(fldlbl(vind,:)),',  zonal component']);

      figure;
      eval(['hsim = plot(tpe2,squeeze(',basename,'rms(:,2,:)));']);
      hold on;
      eval(['hper = plot(tpe2,squeeze(',basename,'rmsp(:,2,:)),', ...
             setstr(39),'--',setstr(39),');']);
      set(gca,'FontName','Times','FontSize',bassize);
      grid on;
      xlim = get (gca,'XLim');
      hdum = plot (xlim,[NaN NaN],'w',xlim,[NaN NaN],'w--');
%      [legh objh outh outm] = legend ([hsim; hsim(1); hper(1)],leglbl);
      [legh objh outh outm] = legend ([hsim; hdum],leglbl);
      set (objh(1),'FontSize',legsize);
      xlabel('Time  (days)');
      ylabel(['RMS error (',deblank(fldunt(vind,:)),')']);
      title([deblank(fldlbl(vind,:)),',  meridional component']);

      figure;
      eval(['hsim = plot(tpe2,squeeze(',basename,'pcc(:,1,:)));']);
      hold on;
      eval(['hper = plot(tpe2,squeeze(',basename,'pccp(:,1,:)),', ...
             setstr(39),'--',setstr(39),');']);
      set(gca,'FontName','Times','FontSize',bassize);
      grid on;
      xlim = get (gca,'XLim');
      hdum = plot (xlim,[NaN NaN],'w',xlim,[NaN NaN],'w--');
%      [legh objh outh outm] = legend ([hsim; hsim(1); hper(1)],leglbl);
      [legh objh outh outm] = legend ([hsim; hdum],leglbl);
      set (objh(1),'FontSize',legsize);
      xlabel('Time  (days)');
      ylabel('Pattern Correlation Coefficient');
      title([deblank(fldlbl(vind,:)),',  zonal component']);

      figure;
      eval(['hsim = plot(tpe2,squeeze(',basename,'pcc(:,2,:)));']);
      hold on;
      eval(['hper = plot(tpe2,squeeze(',basename,'pccp(:,2,:)),', ...
             setstr(39),'--',setstr(39),');']);
      set(gca,'FontName','Times','FontSize',bassize);
      grid on;
      xlim = get (gca,'XLim');
      hdum = plot (xlim,[NaN NaN],'w',xlim,[NaN NaN],'w--');
%      [legh objh outh outm] = legend ([hsim; hsim(1); hper(1)],leglbl);
      [legh objh outh outm] = legend ([hsim; hdum],leglbl);
      set (objh(1),'FontSize',legsize);
      xlabel('Time  (days)');
      ylabel('Pattern Correlation Coefficient');
      title([deblank(fldlbl(vind,:)),',  meridional component']);
   end;

end;
