function [peanaz,pianaz,pcc] = trc_pcc (errtol,petind,pitind,lonlim, ...
                                        latlim,zlev,fldnam,ncpe,ncpi, ...
                                        outid,lon,lat);
%
% function [peanaz,pianaz,pcc] = trc_pcc (errtol,petind,pitind,lonlim, ...
%                                         latlim,zlev,fldnam,ncpe,ncpi, ...
%                                         outid,lon,lat);
%
% This function constructs the PCC fields for a tracer variable.
%
% ------
% Input:
% ------
%
%    ERRTOL   Maximum "OA" error for comparison.
%    PETIND   PE output time level to test.
%    PITIND   Correspondint PE_initial output time level for comparison.
%    LONLIM   Longitude limits for comparison.
%    LATLIM   Latitude limits for comparison.
%    ZLEV     Depth levels for comparison.
%    FLDNAM   Names of fields to compare.
%    NCPE     NetCDF identifier of input PE file to be tested.
%    NCPI     NetCDF identifier of input PE_initial assimilation "truth" file
%    OUTID    Identifier for output ASCII results file.
%    LON,LAT  Horizontal positions.

%-------------------------------------------------------------------------------
% Get basic parameters.
%-------------------------------------------------------------------------------

nz = length(ncpi('level'));

mask   = squeeze(ncpe{'landt'}(:));
actval = 1;
if isempty(mask)
   nx = length(ncpe('tlon'));
   ny = length(ncpe('tlat'));
   mask = actval.*ones(ny,nx);
end;

[ny nx] = size(mask);
peanaz = NaN.*ones(ny,nx,length(zlev));
pianaz = peanaz;
pefldz = peanaz;
pifldz = peanaz;
zwk = abs(squeeze(ncpe{'tgrid3'}(:,:,:,3)));

tfill = ncpe{fldnam}.FillValue_(:);
tifill = ncpi{fldnam}.FillValue_(:);
if ( isempty(tifill) & ~isempty(tfill) )
   tifill = tfill;
 elseif ( isempty(tfill) & ~isempty(tifill) )
   tfill = tifill;
 elseif ( isempty(tfill) & isempty(tifill) )
   tifill = 1.0e35;
   tfill  = tifill;
end;

pcc = NaN.*ones(1,length(zlev)+1);

%-------------------------------------------------------------------------------
% Loop over all times, fields & levels, computing restricted PCC.
%-------------------------------------------------------------------------------

crsssum = 0;
peacsum = 0;
piacsum = 0;

pefld = squeeze(ncpe{fldnam}(petind,:,:,:));
pifld = squeeze(ncpi{fldnam}(pitind,:,:,:));
erfld = squeeze(ncpi{[fldnam,'err']}(pitind,:,:,:));
if isempty(erfld)
   erfld = zeros(size(pefld));
end;

for j = 1:ny
for i = 1:nx
   pefldz(j,i,:) = interp1 (squeeze(zwk(j,i,:)),squeeze(pefld(j,i,:)),zlev);
   pifldz(j,i,:) = interp1 (squeeze(zwk(j,i,:)),squeeze(pifld(j,i,:)),zlev);
   errz(j,i,:)   = interp1 (squeeze(zwk(j,i,:)),squeeze(erfld(j,i,:)),zlev);
end;
end;

clear pefld pifld erfld;

for n = 1:length(zlev)

   msk = zeros(size(mask));
   msk(find(mask==actval)) = 1;
   msk(find(isnan(squeeze(pefldz(:,:,n))) | ...
            (squeeze(pefldz(:,:,n))==tfill) | ...
            (squeeze(pifldz(:,:,n))==tifill) )) = 0;
   erfld = squeeze(errz(:,:,n));
   ind = find (msk==0);
   if ~isempty(ind)
      erfld(ind) = 1 + 2.*abs(errtol);
   end;

   ind = find ( (erfld<=errtol) & (lon>=lonlim(1)) & (lon<=lonlim(2)) ...
                & (lat>=latlim(1)) & (lat<=latlim(2)) & (mask==actval) );

   if ~isempty(ind)

      pefld = squeeze(pefldz(:,:,n));
      pifld = squeeze(pifldz(:,:,n));

      pefld = pefld(ind) - mean(pefld(ind));
      pifld = pifld(ind) - mean(pifld(ind));

      ind3d = ind + (n-1).*nx.*ny;
      peanaz(ind3d) = pefld;
      pianaz(ind3d) = pifld;

      crss = sum(pefld.*pifld);
      peac = sum(pefld.*pefld);
      piac = sum(pifld.*pifld);

      pcc(n) = crss./sqrt(peac.*piac);

      fprintf (outid,'         %f    %f\n',[zlev(n) pcc(n)]);

      crsssum = crsssum + crss;
      peacsum = peacsum + peac;
      piacsum = piacsum + piac;
   end;

end;

pcc(length(zlev)+1) = crsssum./sqrt(peacsum.*piacsum);

fprintf (outid,'\n         Volume PCC = %f\n',pcc(length(zlev)+1));
