function [zdiff,rms] = trc_rms (errtol,petind,pitind,lonlim,latlim, ...
                                         zlev,fldnam,ncpe,ncpi,outid,lon,lat);
%
% function [zdiff,rms] = trc_rms (errtol,petind,pitind,lonlim, ...
%                                   latlim,zlim,fldnam,ncpe,ncpi,outid,lon,lat);
%
% This function constructs the RMS error fields for a tracer variable.
%
% ------
% Input:
% ------
%
%    ERRTOL   Maximum "OA" error for comparison.
%    PETIND   PE output time level to test.
%    PITIND   Correspondint PE_initial output time level for comparison.
%    LONLIM   Longitude limits for comparison.
%    LATLIM   Latitude limits for comparison.
%    ZLEV     Depth levels for comparison.
%    FLDNAM   Names of fields to compare.
%    NCPE     NetCDF identifier of input PE file to be tested.
%    NCPI     NetCDF identifier of input PE_initial assimilation "truth" file
%    OUTID    Identifier for output ASCII results file.
%    LON,LAT  Horizontal positions.

%-------------------------------------------------------------------------------
% Get basic parameters.
%-------------------------------------------------------------------------------

nz = length(ncpi('level'));

mask   = squeeze(ncpe{'landt'}(:));
actval = 1;
if isempty(mask)
   nx = length(ncpe('tlon'));
   ny = length(ncpe('tlat'));
   mask = actval.*ones(ny,nx);
end;

[ny nx] = size(mask);
fdiff = NaN.*ones(ny,nx,nz);
zdiff = NaN.*ones(ny,nx,length(zlev));
zwk   = abs(squeeze(ncpe{'tgrid3'}(:,:,:,3)));

tfill = ncpe{fldnam}.FillValue_(:);
tifill = ncpi{fldnam}.FillValue_(:);
if ( isempty(tifill) & ~isempty(tfill) )
   tifill = tfill;
 elseif ( isempty(tfill) & ~isempty(tifill) )
   tfill = tifill;
 elseif ( isempty(tfill) & isempty(tifill) )
   tifill = 1.0e35;
   tfill  = tifill;
end;

rms = NaN.*ones(1,length(zlev)+1);

%-------------------------------------------------------------------------------
% Loop over all times, fields & levels, computing restricted RMS errors.
%-------------------------------------------------------------------------------

errsum = 0;
nsum   = 0;

%---------------------------------------------
% Test ignoring bottom level on interpolation.
%
for n = 1:nz
%for n = 1:(nz-1)
%---------------------------------------------
   pefld = squeeze(ncpe{fldnam}(petind,:,:,n));
   pifld = squeeze(ncpi{fldnam}(pitind,:,:,n));
   erfld = squeeze(ncpi{[fldnam,'err']}(pitind,:,:,n));
   if isempty(erfld)
      erfld = zeros(size(pefld));
   end;

   ind = find ( (erfld<=errtol) & (lon>=lonlim(1)) & (lon<=lonlim(2)) ...
                & (lat>=latlim(1)) & (lat<=latlim(2)) & (mask==actval) & ...
                 (pefld~=tfill) & (pifld~=tifill) );

   if ~isempty(ind)
      ind3d = ind + (n-1).*nx.*ny;
      fdiff(ind3d) = pefld(ind) - pifld(ind);
   end;
end

for j = 1:ny
for i = 1:nx
   zdiff(j,i,:) = interp1 (squeeze(zwk(j,i,:)),squeeze(fdiff(j,i,:)),zlev);
end;
end;

for n = 1:length(zlev)

   ind = find (~isnan(zdiff(:,:,n)));
   cnt(n) = length(ind);
   if ~isempty(ind)
      ind3d = ind + (n-1).*nx.*ny;
      rms(n) = sqrt(mean( (zdiff(ind3d)).^2 ));

      fprintf (outid,'         %f    %f\n',[zlev(n) rms(n)]);

      errsum = errsum + cnt(n).*rms(n).*rms(n);
      nsum   = nsum + cnt(n);
   end;

end;

rms(length(zlev)+1) = sqrt(errsum./nsum);

fprintf (outid,'\n         Volume RMS Error = %f\n',rms(length(zlev)+1));
