function add_cst (cstfile,landclr,seaclr,cstclr);
%
% function add_cst (cstfile,landclr,seaclr,cstclr);
%
% This function adds coastlines to a figure, using the new
% netCDF version of GSHHS.
%
% ------
% Input:
% ------
%
%    CSTFILE   Name of netCDF GSHHS coastline data file.
%    LANDCLR   Color to use when filling land.
%    SEACLR    Color to use when filling water.
%    CSTCLR    Color to use for drawing boundary.

%-------------------------------------------------------------------------------
% Open coastline netCDF file.
%-------------------------------------------------------------------------------

ncid = netcdf (cstfile);

if isempty(ncid)
   disp (' ');
   disp ('***Error:  ADD_CST - unable to find coastline data file:');
   disp (['           ',setstr(34),cstfile,setstr(34)]);
   disp (' ');
   return;
end;

%-------------------------------------------------------------------------------
% Draw land.
%-------------------------------------------------------------------------------

plot_cst (ncid,'Land',landclr,cstclr);

%-------------------------------------------------------------------------------
% Add lakes.
%-------------------------------------------------------------------------------

plot_cst (ncid,'Lake',seaclr,cstclr);

%-------------------------------------------------------------------------------
% Add islands in lakes.
%-------------------------------------------------------------------------------

plot_cst (ncid,'Island',landclr,cstclr);

%-------------------------------------------------------------------------------
% Add ponds in islands in lakes.
%-------------------------------------------------------------------------------

plot_cst (ncid,'Pond',seaclr,cstclr);

%-------------------------------------------------------------------------------
% Close coastline netCDF file.
%-------------------------------------------------------------------------------

status = close (ncid);

if ~isempty(status)
   disp (' ');
   disp ('***Error:  ADD_CST - unable to close coastline data file:');
   disp (['           ',setstr(34),cstfile,setstr(34)]);
   disp (' ');
   return;
end;
