function pbr_pcc (errtol,petind,pitind,lonlim,latlim,fldnam,ncpe,ncpi, ...
                  outid,lon,lat);
%
% function pbr_pcc (errtol,petind,pitind,lonlim,latlim,fldnam,ncpe,ncpi, ...
%                   outid,lon,lat);
%
% This function constructs the RMS error fields for the transport
% streamfunction.
%
% ------
% Input:
% ------
%
%    ERRTOL   Maximum "OA" error for comparison.
%    PETIND   PE output time level to test.
%    PITIND   Correspondint PE_initial output time level for comparison.
%    LONLIM   Longitude limits for comparison.
%    LATLIM   Latitude limits for comparison.
%    FLDNAM   Names of fields to compare.
%    NCPE     NetCDF identifier of input PE file to be tested.
%    NCPI     NetCDF identifier of input PE_initial assimilation "truth" file
%    OUTID    Identifier for output ASCII results file.
%    LON,LAT  Horizontal positions.

%-------------------------------------------------------------------------------
% Get basic parameters.
%-------------------------------------------------------------------------------

mask   = squeeze(ncpe{'landt'}(:));
actval = 1;
if isempty(mask)
   nx = length(ncpe('tlon'));
   ny = length(ncpe('tlat'));
   mask = actval.*ones(ny,nx);
end;

[j i]= find (mask==actval);

pfill = ncpe{fldnam}.FillValue_(:);
pifill = ncpi{fldnam}.FillValue_(:);
if ( isempty(pifill) & ~isempty(pfill) )
   pifill = pfill;
 elseif ( isempty(pfill) & ~isempty(pifill) )
   pfill = pifill;
 elseif ( isempty(pfill) & isempty(pifill) )
   pifill = 1.0e35;
   pfill  = pifill;
end;

ppe1 = squeeze(ncpe{fldnam}(petind,j(1),i(1)));
ppi1 = squeeze(ncpi{fldnam}(pitind,j(1),i(1)));

cgs2Sv = 1e-12;

%-------------------------------------------------------------------------------
% Loop over all times, fields & levels, computing restricted RMS errors.
%-------------------------------------------------------------------------------

pefld = (squeeze(ncpe{fldnam}(petind,:,:))-ppe1).*cgs2Sv;
pifld = (squeeze(ncpi{fldnam}(pitind,:,:))-ppi1).*cgs2Sv;
erfld = squeeze(ncpi{[fldnam,'err']}(pitind,:,:));
if isempty(erfld)
   erfld = zeros(size(pefld));
end;

ind = find ( (erfld<=errtol) & (lon>=lonlim(1)) & (lon<=lonlim(2)) ...
                 & (lat>=latlim(1)) & (lat<=latlim(2)) & (mask==actval) & ...
                 (pefld~=pfill) & (pifld~=pifill) );

if ~isempty(ind)

   pefld = pefld(ind) - mean(pefld(ind));
   pifld = pifld(ind) - mean(pifld(ind));

   crss = sum(pefld.*pifld);
   peac = sum(pefld.*pefld);
   piac = sum(pifld.*pifld);

   pcc = crss./sqrt(peac.*piac);

   fprintf (outid,'         %4d    %f\n',[1 pcc]);
end;
