function [errtol,petims,pitims,lonlim,latlim,zlev,fldnam,pefile,pifile, ...
                              outfil,outmat,status] = pe_rmse_parm (parmfile);
%
% function [errtol,petims,pitims,lonlim,latlim,zlev,fldnam,pefile,pifile, ...
%                             outfil,outmat,status] = pe_rmse_parm (parmfile);
%
% This function reads in the parameters to run the bottom extension of dynamic
% height script.
%
% ------
% Input:
% ------
%
%    PARMFILE    Name of parameter input file.
%
% -------
% Output:
% -------
%
%    ERRTOL   Maximum "OA" error for comparison.
%    PETIMS   PE output time levels to test.
%    PITIMS   Correspondint PE_initial output time levels for comparison.
%    LONLIM   Longitude limits for comparison.
%    LATLIM   Latitude limits for comparison.
%    ZLEV     Depth levels for comparison.
%    FLDNAM   Names of fields to compare.
%    PEFILE   Name of input PE netCDF file to be tested.
%    PIFILE   Name of input PE_initial assimilation netCDF "truth" file
%    OUTFIL   Name of output statistic file
%    OUTMAT   Name for output MATLAB file
%    STATUS   Exit status;

%-------------------------------------------------------------------------------
% Set default values.
%-------------------------------------------------------------------------------

errtol = [];
petims = [];
pitims = [];
lonlim = [];
latlim = [];
zlev   = [];
fldnam = '';
pefile = '';
pifile = '';
outfil = '';
outmat = '';

%-------------------------------------------------------------------------------
% Open parameter input file.
%-------------------------------------------------------------------------------

[fid,mess] = fopen (parmfile,'r');

if (fid<0)
   disp (' ');
   disp ('***Error:  PE_RMSE_PARM - unable to open parameter input file:');
   disp (['           ',setstr(34),parmfile,setstr(34)]);
   disp (['           ',setstr(34),mess,setstr(34)]);
   status = fid;
   return;
end;

%-------------------------------------------------------------------------------
% Read run parameters.
%-------------------------------------------------------------------------------

errtol = num_read (fid);
petims = num_read (fid);
pitims = num_read (fid);
lonlim = num_read (fid);
latlim = num_read (fid);
zlev   = num_read (fid);
fldlin = fgetl (fid);
pefile = fgetl (fid);
pifile = fgetl (fid);
outfil = fgetl (fid);
outmat = fgetl (fid);

%-------------------------------------------------------------------------------
% Extract field names.
%-------------------------------------------------------------------------------

fldlin = deblank(fldlin);
indst  = max([0 findstr(fldlin,setstr(32)) findstr(fldlin,setstr(9))]) + 1;
indstr = indst:length(fldlin);
fldnam = fldlin(indstr);
fldlin(indstr) = [];

while ~isempty(fldlin)
   fldlin = deblank(fldlin);
   indst  = max([0 findstr(fldlin,setstr(32)) findstr(fldlin,setstr(9))]) + 1;
   indstr = indst:length(fldlin);
   fldnam = strvcat(fldlin(indstr),fldnam);
   fldlin(indstr) = [];
end

%-------------------------------------------------------------------------------
% Close parameter input file.
%-------------------------------------------------------------------------------

status = fclose (fid);

if (status<0)
   disp (' ');
   disp ('***Error:  PE_RMSE_PARM - unable to close parameter input file:');
   disp (['           ',setstr(34),parmfile,setstr(34)]);
end;
