function plot_cst (ncid,type,fillclr,edgeclr);
%
% function plot_cst (ncid,type,fillclr,edgeclr);
%
% This function adds one type of coast line to the current plot.
%
% ------
% Input:
% ------
%
%    NCID      NetCDF identifier for opened coastline dataset.
%    TYPE      Type of coastline to add.
%               "Land"     coastlines separating land from ocean
%               "Lake"     coastlines defining land-locked lakes
%               "Island"   coastlines defining islands within lakes
%               "Pond"     coastlines defining ponds within islands within lakes
%    FILLCLR   Color to use in filling coastlines.
%    EDGECLR   Color to use in drawing coastlines.

%-------------------------------------------------------------------------------
% Get current plot limits.
%-------------------------------------------------------------------------------

lonlim = get (gca,'XLim');
latlim = get (gca,'YLim');

%-------------------------------------------------------------------------------
% Look for bounding box.  If not found, assume the requested coastal type
% is not included in file.
%-------------------------------------------------------------------------------

box = ncid{[lower(type),'box']}(:);

if isempty(box)
   return;
end;

[ncst, nside] = size(box);

%-------------------------------------------------------------------------------
% Examine each box.  If it intersects the plot window, add the coastline.
%-------------------------------------------------------------------------------

nant = ncid.antarctica(:);
if (isempty(nant) | ~strcmp(upper(type),'LAND'))
   nant=-1;
end;

for n = 1:ncst

   if (n~=nant)
      if ~( (box(n,2)<lonlim(1)) | (box(n,1)>lonlim(2)) | ...
            (box(n,4)<latlim(1)) | (box(n,3)>latlim(2)) )
         deltas = ncid{[lower(type),'index']}(n,1:2);
         pos    = ncid{lower(type)}((deltas(1)+(1:deltas(2))),:);
         h = patch (pos(:,1),pos(:,2),fillclr);
         set (h,'EdgeColor',edgeclr);
      end;
    else
      if ~( (box(n,4)<latlim(1)) | (box(n,3)>latlim(2)) )
         deltas = ncid{[lower(type),'index']}(n,1:2);
         pos    = ncid{lower(type)}((deltas(1)+(1:deltas(2))),:);
         [npt nvc] = size(pos);
         pos(npt+1,:) = [180 -90];
         pos(npt+1,:) = [-180 -90];
         h = patch (pos(:,1),pos(:,2),fillclr);
         set (h,'EdgeColor',edgeclr);
      end;
   end;

end;
