function rms_pe (errtol,petims,pitims,lonlim,latlim,zlev,fldnam,ncpe,ncpi, ...
                 outid,outmat);
%
% function rms_pe (errtol,petims,pitims,lonlim,latlim,zlev,fldnam,ncpe,ncpi, ...
%                  outid,outmat);
%
% This function reads in the parameters to run the bottom extension of dynamic
% height script.
%
% ------
% Input:
% ------
%
%    ERRTOL   Maximum "OA" error for comparison.
%    PETIMS   PE output time levels to test.
%    PITIMS   Correspondint PE_initial output time levels for comparison.
%    LONLIM   Longitude limits for comparison.
%    LATLIM   Latitude limits for comparison.
%    ZLEV     Depth levels for comparison.
%    FLDNAM   Names of fields to compare.
%    NCPE     NetCDF identifier of input PE file to be tested.
%    NCPI     NetCDF identifier of input PE_initial assimilation "truth" file
%    OUTID    Identifier for output ASCII results file.
%    OUTMAT   Name for output MATLAB file

%-------------------------------------------------------------------------------
% Get basic parameters.
%-------------------------------------------------------------------------------

[nfld mxchr] = size(fldnam);

tlon = squeeze(ncpe{'tgrid3'}(:,:,1,1));
tlat = squeeze(ncpe{'tgrid3'}(:,:,1,2));

vlon = squeeze(ncpe{'vgrid3'}(:,:,1,1));
vlat = squeeze(ncpe{'vgrid3'}(:,:,1,2));

%-------------------------------------------------------------------------------
% Loop over all times, fields & levels, computing restricted RMS errors.
%-------------------------------------------------------------------------------

savestr = '';

for tind = 1:length(petims);

   tpe(tind) = ncpe{'time'}(petims(tind))./86400;
   tpi(tind) = ncpi{'time'}(pitims(tind));

   fprintf (outid,['\n----------------------------------------', ...
                   '----------------------------------------\n\n', ...
                  'Comparisons at\n   PE time:          %f days\n   ', ...
                 'PE_initial time:  %f'],[tpe(tind) tpi(tind)]);
   fprintf (outid,'  (%s)\n',pjh_greg(tpi(tind)));

   for vind = 1:nfld;

      ncname = deblank(fldnam(vind,:));

      fprintf (outid,'\n%s\n         Level   RMS Error\n', ...
               deblank(ncpe{ncname}.long_name(:)));

      if (length(size(ncpe{deblank(fldnam(vind,:))})) == 4)
         [fdiff,rms] = trc_rms (errtol,petims(tind),pitims(tind), ...
                                     lonlim,latlim,zlev,ncname,ncpe,ncpi, ...
                                     outid,tlon,tlat);
         eval ([ncname,'fdiff(',num2str(tind),',:,:,:) = fdiff;']);
         eval ([ncname,'rms(',num2str(tind),',:) = rms;']);
         if (tind==1)
            savestr = [savestr,' ',ncname,'fdiff', ...
                               ' ',ncname,'rms'];
         end;

       elseif (length(size(ncpe{deblank(fldnam(vind,:))})) == 5)
         [urms,vrms] = vel_rms (errtol,petims(tind),pitims(tind),lonlim, ...
                                latlim,zlev,ncname,ncpe,ncpi,outid,vlon,vlat);
         eval ([ncname,'rms(',num2str(tind),',1,:) = urms;']);
         eval ([ncname,'rms(',num2str(tind),',2,:) = vrms;']);
         if (tind==1)
            savestr = [savestr,' ',ncname,'rms'];
         end;

       else
         pbr_rms (errtol,petims(tind),pitims(tind),lonlim,latlim, ...
                  ncname,ncpe,ncpi,outid,tlon,tlat);
      end

   end;

end;

eval (['save ',outmat,' tlon tlat zlev tpe tpi',savestr]);
