function [zplot,pltnd,lonlim,latlim,fldnam,cst_file,persrms, ...
                   perspcc,simrms,simpcc,status] = skill_dist_parm (parmfile);
%
% function [zplot,pltnd,lonlim,latlim,fldnam,cst_file,persrms, ...
%                   perspcc,simrms,simpcc,status] = skill_dist_parm (parmfile);
%
% This function reads in the parameters to run the bottom extension of dynamic
% height script.
%
% ------
% Input:
% ------
%
%    PARMFILE    Name of parameter input file.
%
% -------
% Output:
% -------
%
%    ZPLOT      Depth at which to plot statistic-related fields.
%    PLTND      Index of field to plot.
%    LONLIM     Suggested longitude limits for plot.
%    LATLIM     Suggested latitude limits for plot.
%    FLDNAM     Names of fields to compare.
%    CST_FILE   GSSHS coastline netCDF file.
%    PERSRMS    Name of MATLAB file containing persistence RMS statistics.
%    PERSPCC    Name of MATLAB file containing persistence PCC statistics.
%    SIMRMS     Name of MATLAB file containing forecast RMS statistics.
%    SIMPCC     Name of MATLAB file containing forecast PCC statistics.
%    STATUS     Exit status;

%-------------------------------------------------------------------------------
% Set default values.
%-------------------------------------------------------------------------------

zplot    = [];
pltnd    = [];
lonlim   = [];
latlim   = [];
fldnam   = '';
cst_file = '';
persrms  = '';
perspcc  = '';
simrms   = '';
simpcc   = '';

%-------------------------------------------------------------------------------
% Open parameter input file.
%-------------------------------------------------------------------------------

[fid,mess] = fopen (parmfile,'r');

if (fid<0)
   disp (' ');
   disp ('***Error:  SKILL_DIST_PARM - unable to open parameter input file:');
   disp (['           ',setstr(34),parmfile,setstr(34)]);
   disp (['           ',setstr(34),mess,setstr(34)]);
   status = fid;
   return;
end;

%-------------------------------------------------------------------------------
% Read run parameters.
%-------------------------------------------------------------------------------

zplot    = num_read (fid);
pltnd    = num_read (fid);
lonlim   = num_read (fid);
latlim   = num_read (fid);
fldlin   = fgetl (fid);
cst_file = fgetl (fid);
persrms  = fgetl (fid);
perspcc  = fgetl (fid);
simrms   = fgetl (fid);
simpcc   = fgetl (fid);

%-------------------------------------------------------------------------------
% Extract field names.
%-------------------------------------------------------------------------------

fldlin = deblank(fldlin);
indst  = max([0 findstr(fldlin,setstr(32)) findstr(fldlin,setstr(9))]) + 1;
indstr = indst:length(fldlin);
fldnam = fldlin(indstr);
fldlin(indstr) = [];

while ~isempty(fldlin)
   fldlin = deblank(fldlin);
   indst  = max([0 findstr(fldlin,setstr(32)) findstr(fldlin,setstr(9))]) + 1;
   indstr = indst:length(fldlin);
   fldnam = strvcat(fldlin(indstr),fldnam);
   fldlin(indstr) = [];
end

%-------------------------------------------------------------------------------
% Close parameter input file.
%-------------------------------------------------------------------------------

status = fclose (fid);

if (status<0)
   disp (' ');
   disp ('***Error:  SKILL_DIST_PARM - unable to close parameter input file:');
   disp (['           ',setstr(34),parmfile,setstr(34)]);
end;
