function statplt (lon,lat,fld,lnlm,ltlm,cst_file,clvl);
%
% function statplt (lon,lat,fld,lnlm,ltlm,cst_file,clvl);
%
% This function creates a plot of the given, statistic
% related field.
%
% ------
% Input:
% ------
%
%   LON        Longitudes of given field.
%   LAT        Latitudes of given field.
%   FLD        2D field.
%   CST_FILE   GSSHS coastline netCDF file.
%   CLVL       Contour levels.

%-------------------------------------------------------------------------------
% Set useful constants.
%-------------------------------------------------------------------------------

[ny nx nz] = size(fld);

land_color  = 0.75.*[0.86 0.58 0.44];
cst_color   = 0.5.*land_color;

bkgndcolor = [0.75 0.875 1];

%-------------------------------------------------------------------------------
% Set plot ranges.
%-------------------------------------------------------------------------------

lonlim = extrem(lon);
latlim = extrem(lat);

lonlim = [max([lonlim(1) lnlm(1)]) min([lonlim(2) lnlm(2)])];
latlim = [max([latlim(1) ltlm(1)]) min([latlim(2) ltlm(2)])];

aspect = cos(mean(latlim).*pi./180);

%-------------------------------------------------------------------------------
% Plot field.
%-------------------------------------------------------------------------------

fill (lonlim([1 2 2 1 1]),latlim([1 1 2 2 1]),bkgndcolor);
set(gca,'Xlim',lonlim, ...
        'Ylim',latlim, ...
        'FontName','Times', ...
        'DataAspectRatio',[1 aspect 1], ...
        'FontSize',14);

hold on;

xtk = get (gca,'XTick');
ytk = get (gca,'YTick');

[X Y] = meshgrid (xtk,latlim);
plot (X,Y,'k:');

[X Y] = meshgrid (lonlim,ytk);
plot (X',Y','k:');

set (gca,'XTick',xtk,'YTick',ytk);

%clvl = nice(extrem(fld),4);
caxis(extrem(clvl));
[C,H,CF] = contourf (lon,lat,fld,clvl);
set (H,'EdgeColor','w','LineWidth',1/12);
%h = colorbarf (C,H);
%h = colorbarf_pjh (C,H);
%h = colorbarfudge (C,H,clvl);
h = colorbarclvl (C,H,clvl);

add_cst (cst_file,land_color,bkgndcolor,cst_color);
