function [fldnam,fldlbl,fldunt,rmsp_file, ...
          pccp_file,rms_file,pcc_file,status] = stats_view_parm (parmfile);
%
% function [fldnam,fldlbl,fldunt,rmsp_file, ...
%           pccp_file,rms_file,pcc_file,status] = stats_view_parm (parmfile);
%
% This function reads in the parameters to plot the skill metric statistics.
%
% ------
% Input:
% ------
%
%    PARMFILE    Name of parameter input file.
%
% -------
% Output:
% -------
%
%    FLDNAM      Names of fields to compare.
%    FLDLBL      Plotting labels for fields.
%    FLDUNT      Units for fields
%    RMSP_FILE   Root-Mean Square error file for persistence fields.
%    PCCP_FILE   Pattern Correlation Coefficient file for persistence fields.
%    RMS_FILE    Root-Mean Square error file for simulation fields.
%    PCC_FILE    Pattern Correlation Coefficient file for simulation fields.
%    STATUS      Exit status;

%-------------------------------------------------------------------------------
% Set default values.
%-------------------------------------------------------------------------------

fldnam    = '';
fldlbl    = '';
fldunt    = '';
rmsp_file = '';
pccp_file = '';
rms_file  = '';
pcc_file  = '';

%-------------------------------------------------------------------------------
% Open parameter input file.
%-------------------------------------------------------------------------------

[fid,mess] = fopen (parmfile,'r');

if (fid<0)
   disp (' ');
   disp ('***Error:  STATS_VIEW_PARM - unable to open parameter input file:');
   disp (['           ',setstr(34),parmfile,setstr(34)]);
   disp (['           ',setstr(34),mess,setstr(34)]);
   status = fid;
   return;
end;

%-------------------------------------------------------------------------------
% Read run parameters.
%-------------------------------------------------------------------------------

fldlin    = fgetl (fid);
lblin     = fgetl (fid);
unitin    = fgetl (fid);
rmsp_file = fgetl (fid);
pccp_file = fgetl (fid);
rms_file  = fgetl (fid);
pcc_file  = fgetl (fid);

%-------------------------------------------------------------------------------
% Extract field names.
%-------------------------------------------------------------------------------

fldlin = deblank(fldlin);
indst  = max([0 findstr(fldlin,setstr(32)) findstr(fldlin,setstr(9))]) + 1;
indstr = indst:length(fldlin);
fldnam = fldlin(indstr);
fldlin(indstr) = [];

while ~isempty(fldlin)
   fldlin = deblank(fldlin);
   indst  = max([0 findstr(fldlin,setstr(32)) findstr(fldlin,setstr(9))]) + 1;
   indstr = indst:length(fldlin);
   fldnam = strvcat(fldlin(indstr),fldnam);
   fldlin(indstr) = [];
end

%-------------------------------------------------------------------------------
% Extract field descriptors.
%-------------------------------------------------------------------------------

lblin = deblank(lblin);
indst  = max([0 findstr(lblin,setstr(32)) findstr(lblin,setstr(9))]) + 1;
indstr = indst:length(lblin);
fldlbl = lblin(indstr);
lblin(indstr) = [];

while ~isempty(lblin)
   lblin = deblank(lblin);
   indst  = max([0 findstr(lblin,setstr(32)) findstr(lblin,setstr(9))]) + 1;
   indstr = indst:length(lblin);
   fldlbl = strvcat(lblin(indstr),fldlbl);
   lblin(indstr) = [];
end

%-------------------------------------------------------------------------------
% Extract field units.
%-------------------------------------------------------------------------------

unitin = deblank(unitin);
indst  = max([0 findstr(unitin,setstr(32)) findstr(unitin,setstr(9))]) + 1;
indstr = indst:length(unitin);
fldunt = unitin(indstr);
unitin(indstr) = [];

while ~isempty(unitin)
   unitin = deblank(unitin);
   indst  = max([0 findstr(unitin,setstr(32)) findstr(unitin,setstr(9))]) + 1;
   indstr = indst:length(unitin);
   fldunt = strvcat(unitin(indstr),fldunt);
   unitin(indstr) = [];
end

%-------------------------------------------------------------------------------
% Close parameter input file.
%-------------------------------------------------------------------------------

status = fclose (fid);

if (status<0)
   disp (' ');
   disp ('***Error:  STATS_VIEW_PARM - unable to close parameter input file:');
   disp (['           ',setstr(34),parmfile,setstr(34)]);
end;
