function [upcc,vpcc] = vel_pcc (errtol,petind,pitind,lonlim,latlim, ...
                                 zlev,fldnam,ncpe,ncpi,outid,lon,lat);
%
% function [upcc,vpcc] = vel_pcc (errtol,petind,pitind,lonlim,latlim, ...
%                                  zlev,fldnam,ncpe,ncpi,outid,lon,lat);
%
% This function constructs the PCC fields for a velocity variable.
%
% ------
% Input:
% ------
%
%    ERRTOL   Maximum "OA" error for comparison.
%    PETIND   PE output time level to test.
%    PITIND   Correspondint PE_initial output time level for comparison.
%    LONLIM   Longitude limits for comparison.
%    LATLIM   Latitude limits for comparison.
%    ZLEV     Depth levels for comparison.
%    FLDNAM   Names of fields to compare.
%    NCPE     NetCDF identifier of input PE file to be tested.
%    NCPI     NetCDF identifier of input PE_initial assimilation "truth" file
%    OUTID    Identifier for output ASCII results file.
%    LON,LAT  Horizontal positions.

%-------------------------------------------------------------------------------
% Get basic parameters.
%-------------------------------------------------------------------------------

nz = length(ncpi('level'));

mask   = squeeze(ncpe{'landv'}(:));
actval = 2;
if isempty(mask)
   nx = length(ncpe('vlon'));
   ny = length(ncpe('vlat'));
   mask = actval.*ones(ny,nx);
end;

[ny nx] = size(mask);
pefldz = NaN.*ones(ny,nx,length(zlev));;
pifldz = pefldz;
zwk = abs(squeeze(ncpe{'vgrid3'}(:,:,:,3)));

vfill = ncpe{fldnam}.FillValue_(:);
vifill = ncpi{fldnam}.FillValue_(:);
if ( isempty(vifill) & ~isempty(vfill) )
   vifill = vfill;
 elseif ( isempty(vfill) & ~isempty(vifill) )
   vfill = vifill;
 elseif ( isempty(vfill) & isempty(vifill) )
   vifill = 1.0e35;
   vfill  = vifill;
end;

upcc = NaN.*ones(1,length(zlev)+1);
vpcc = upcc;

%-------------------------------------------------------------------------------
% Loop over all times, fields & levels, computing restricted PCC.
%-------------------------------------------------------------------------------

fprintf (outid,'\n   Zonal\n\n');

velind = 1;
crsssum = 0;
peacsum = 0;
piacsum = 0;

pefld = squeeze(ncpe{fldnam}(petind,:,:,:,velind));
pifld = squeeze(ncpi{fldnam}(pitind,:,:,:,velind));
erfld = squeeze(ncpi{[fldnam,'err']}(pitind,:,:,:,velind));
if isempty(erfld)
   erfld = zeros(size(pefld));
end;

for j = 1:ny
for i = 1:nx
   pefldz(j,i,:) = interp1 (squeeze(zwk(j,i,:)),squeeze(pefld(j,i,:)),zlev);
   pifldz(j,i,:) = interp1 (squeeze(zwk(j,i,:)),squeeze(pifld(j,i,:)),zlev);
   errz(j,i,:)   = interp1 (squeeze(zwk(j,i,:)),squeeze(erfld(j,i,:)),zlev);
end;
end;

clear pefld pifld erfld;

for n = 1:length(zlev)

   msk = zeros(size(mask));
   msk(find(mask==actval)) = 1;
   msk(find(isnan(squeeze(pefldz(:,:,n))) | ...
            (squeeze(pefldz(:,:,n))==vfill) | ...
            (squeeze(pifldz(:,:,n))==vifill) )) = 0;
   erfld = squeeze(errz(:,:,n));
   ind = find (msk==0);
   if ~isempty(ind)
      erfld(ind) = 1 + 2.*abs(errtol);
   end;

   ind = find ( (erfld<=errtol) & (lon>=lonlim(1)) & (lon<=lonlim(2)) ...
                 & (lat>=latlim(1)) & (lat<=latlim(2)) & (mask==actval) );

   if ~isempty(ind)

      pefld = squeeze(pefldz(:,:,n));
      pifld = squeeze(pifldz(:,:,n));

      pefld = pefld(ind) - mean(pefld(ind));
      pifld = pifld(ind) - mean(pifld(ind));

      crss = sum(pefld.*pifld);
      peac = sum(pefld.*pefld);
      piac = sum(pifld.*pifld);

      upcc(n) = crss./sqrt(peac.*piac);

      fprintf (outid,'         %f    %f\n',[zlev(n) upcc(n)]);

      crsssum = crsssum + crss;
      peacsum = peacsum + peac;
      piacsum = piacsum + piac;
   end;

end;

upcc(length(zlev)+1) = crsssum./sqrt(peacsum.*piacsum);

fprintf (outid,'\n         Volume PCC = %f\n',upcc(length(zlev)+1));

fprintf (outid,'\n   Meridional\n\n');

velind = 2;
crsssum = 0;
peacsum = 0;
piacsum = 0;

pefld = squeeze(ncpe{fldnam}(petind,:,:,:,velind));
pifld = squeeze(ncpi{fldnam}(pitind,:,:,:,velind));
erfld = squeeze(ncpi{[fldnam,'err']}(pitind,:,:,:,velind));
if isempty(erfld)
   erfld = zeros(size(pefld));
end;

for j = 1:ny
for i = 1:nx
   pefldz(j,i,:) = interp1 (squeeze(zwk(j,i,:)),squeeze(pefld(j,i,:)),zlev);
   pifldz(j,i,:) = interp1 (squeeze(zwk(j,i,:)),squeeze(pifld(j,i,:)),zlev);
   errz(j,i,:)   = interp1 (squeeze(zwk(j,i,:)),squeeze(erfld(j,i,:)),zlev);
end;
end;

clear pefld pifld erfld;

for n = 1:length(zlev)

   msk = zeros(size(mask));
   msk(find(mask==actval)) = 1;
   msk(find(isnan(squeeze(pefldz(:,:,n))) | ...
            (squeeze(pefldz(:,:,n))==vfill) | ...
            (squeeze(pifldz(:,:,n))==vifill) )) = 0;
   erfld = squeeze(errz(:,:,n));
   ind = find (msk==0);
   if ~isempty(ind)
      erfld(ind) = 1 + 2.*abs(errtol);
   end;

   ind = find ( (erfld<=errtol) & (lon>=lonlim(1)) & (lon<=lonlim(2)) ...
                 & (lat>=latlim(1)) & (lat<=latlim(2)) & (mask==actval) );

   if ~isempty(ind)

      pefld = squeeze(pefldz(:,:,n));
      pifld = squeeze(pifldz(:,:,n));

      pefld = pefld(ind) - mean(pefld(ind));
      pifld = pifld(ind) - mean(pifld(ind));

      crss = sum(pefld.*pifld);
      peac = sum(pefld.*pefld);
      piac = sum(pifld.*pifld);

      vpcc(n) = crss./sqrt(peac.*piac);

      fprintf (outid,'         %f    %f\n',[zlev(n) vpcc(n)]);

      crsssum = crsssum + crss;
      peacsum = peacsum + peac;
      piacsum = piacsum + piac;
   end;

end;

vpcc(length(zlev)+1) = crsssum./sqrt(peacsum.*piacsum);

fprintf (outid,'\n         Volume PCC = %f\n',vpcc(length(zlev)+1));
