% Sea-Surface Temperature (SST) Remapping Package
%
% A collection of routines to process SST GIF images for Use in HOPS.
%
% The SST is extended in the vertical.  The extension employed is a
% constant extension throughout the mixed layer.
%
% Error fields, corresponding to the SST fields are constructed.  In the
% horizontal, the nondimensional fields are chosen to be small where there
% is data and large where there is none.  In the vertical, the error field
% is increased (nonlinearly) in depth to an unassimilatable value at the
% base of the mixed layer.
%
% This package is written to be included in your Matlab path.  Then processing
% an SST file only requires bringing a copy of the desired _.in file to the
% processing directory.
%
% Some of these routines assume that the CSIRO SeaWater package is in the
% matlab path ( http://www.marine.csiro.au/~morgan/seawater/ ).
%
% --------
% Drivers:
% --------
%
%    sstgif2oa.....Drives "mapping" of an SST GIF image onto a HOPS OA(G)/FM
%                  netCDF file.
%
% -------------
% Input/Output:
% -------------
%
%    comb_oa............Combine Temperature & Temperature Error contents of a
%                       HOPS OA(G)/FM file with SST in estimated mixed layer.
%    num_read...........Reads a number from a single line of an ASCII file.
%    read_flx2..........Read windstress & net heatflux from PE_forcing output.
%    rep_oa.............Overwrite Temperature & Temperature Error contents of a
%                       HOPS OA(G)/FM file with SST in estimated mixed layer.
%    sstgif2oa_inparm...Read run parameters for SSTGIF2OA.
%
% -----------
% Processing:
% -----------
%
%    get_colbar........Extract colorbar data from SST image.
%    get_sst...........Extract SST data from image.
%    parse_sst.........Interactive GUI function to get image mapping data.
%    smooth_under_iw...Function to fill in "missing" data.
%
% ------
% Misc.:
% ------
%
%    ann_tic............"Annotated TIC".  Delivers message and starts elapsed
%                       time clock.
%    extrem.............Finds the extrema of a field.
%    hms_toc............"Hour:Minute:Second TOC".  Reports elapsed time in
%                       hour:minute:second format.
