function val = num_read (fid);
%
% function val = num_read (fid);
%
% This function reads in a single number from a line
% of an ASCII file.
%
% Input:
%
%    FID   The file identification number.
%
% Output:
%
%    VAL   The value read.  (Empty for end of file.)
%

%-------------------------------------------------------------------------------
% Initialize output.
%-------------------------------------------------------------------------------

val = [];

%-------------------------------------------------------------------------------
% Read in a line of text.
%-------------------------------------------------------------------------------

txt = fgetl(fid);

%-------------------------------------------------------------------------------
% If not end of file, parse for numeric data.
%-------------------------------------------------------------------------------

if any(txt~=-1),

   %---------------------------------------
   %--- Find beginning of numeric data. ---
   %---------------------------------------

   ntxt = length(txt);
   n = 1;

   while ((n<ntxt) & ( (txt(n:n)==setstr(32)) | (txt(n:n)==setstr(9)) )),
      n = n + 1;
   end

   nst = n;

   %------------------------------------
   %--- Find ending of numeric data. ---
   %------------------------------------

   if ~strcmp(txt(nst:nst),'[')

      while ((n<ntxt) & (txt(n:n)~=setstr(32)) & (txt(n:n)~=setstr(9))),
         n = n + 1;
      end

      nnd = n;
      if ( (txt(nnd:nnd)==setstr(32)) | (txt(nnd:nnd)==setstr(9)) ),
         nnd = nnd - 1;
      end

    else

      nnd = min(findstr(txt,']'));

   end

   %-----------------------------
   %--- Extract numeric data. ---
   %-----------------------------

   val = str2num(txt(nst:nnd));

end;
