function status = rep_oa (temp,terrsm,tstd,zmld,jdate,oafile);
%
% function status = rep_oa (temp,terrsm,tstd,zmld,jdate,oafile);
%
% This function replaces the Temperature field in an OA(G)/FM
% file with the SST & error fields.

%-------------------------------------------------------------------------------
% Open netCDF file.
%-------------------------------------------------------------------------------

status = mexcdf ('setopts',0);

ncid = netcdf (oafile,'write');

if isempty(ncid)
   disp (' ');
   disp ('***Error:  REP_OA - unable to open OA(G)/FM file:');
   disp (['           ',setstr(34),oafile,setstr(34)]);
   disp (' ');
   status = -1;
   return;
end;

%-------------------------------------------------------------------------------
% Determine number of vertical levels & the depths.
%-------------------------------------------------------------------------------

name = 'level';
nz = size(ncid(name));

if isempty(nz)
   disp (' ');
   disp (['***Error:  REP_OA - unable to read dimension ',setstr(34), ...
          name,setstr(34),' in OA(G)/FM file:']);
   disp (['           ',setstr(34),oafile,setstr(34)]);
   disp (' ');
   status = -1;
   return;
end;

name = 'zout';
z = squeeze(ncid{name}(:,3));

if isempty(z)
   disp (' ');
   disp (['***Error:  REP_OA - unable to read variable ',setstr(34), ...
          name,setstr(34),' in OA(G)/FM file:']);
   disp (['           ',setstr(34),oafile,setstr(34)]);
   disp (' ');
   status = -1;
   return;
end;

%-------------------------------------------------------------------------------
% Nondimensionalize SST error.
%-------------------------------------------------------------------------------

terrsm = terrsm./tstd;
terrsm = terrsm.*terrsm;

%-------------------------------------------------------------------------------
% Replace SST in upper levels.
%-------------------------------------------------------------------------------

ind = find ( ~isnan(temp) );
nrep = max(find(abs(z)<=max(abs(zmld(ind)))));

ncid{'time'}(1) = jdate;

for n = 1:nrep;

   twk = squeeze(ncid{'temp'}(1,:,:,n));
   ind = find ( ~isnan(temp) );

   twk(ind) = temp(ind);
   ncid{'temp'}(1,:,:,n) = twk;

   ewk = terrsm(ind);
   indwk = find(ewk>1);
   if ~isempty(indwk)
      ewk(indwk) = 1;
   end;

   wt = abs(z(n)./zmld(ind));
   indwk = find (abs(zmld(ind))==0);
   if ~isempty(indwk)
      wt(indwk) = 1;
   end;
   indwk = find (wt>1);
   if ~isempty(indwk)
      wt(indwk) = 1;
   end;
   wt = wt.^4;

   ewk = ewk.*(1-wt) + wt;

   twk = squeeze(ncid{'temperr'}(1,:,:,n));
   twk = ones(size(twk)).*squeeze(ncid{'temprmsdev'}(1,n));
   twk(ind) = sqrt(ewk).*squeeze(ncid{'temprmsdev'}(1,n));
   ncid{'temperr'}(1,:,:,n) = twk;

end;

%-------------------------------------------------------------------------------
% Wipe-out error fields in lower levels.
%-------------------------------------------------------------------------------

for n=(nrep+1):nz

   ncid{'temperr'}(1,:,:,n) = ones(size(temp)).* ...
                              squeeze(ncid{'temprmsdev'}(1,n));

end;

%-------------------------------------------------------------------------------
% Close netCDF file.
%-------------------------------------------------------------------------------

status = close (ncid);

if ~isempty(status)
   disp (' ');
   disp ('***Error:  REP_OA - unable to close OA(G)/FM file:');
   disp (['           ',setstr(34),oafile,setstr(34)]);
   disp (' ');
   status = -1;
   return;
end;

status = 0;
