function [lon,lat,x,y,excldx,excldy,barx,bary,trange,relrng] = ...
                                                      parse_sst (sst,sstmap);
%
% function [lon,lat,x,y,excldx,excldy,barx,bary,trange,relrng] = ...
%                                                       parse_sst (sst,sstmap);
%
% This function drives the user in extracting navigation/mapping information
% data from an SST image.

%-------------------------------------------------------------------------------
% Initialize output.
%-------------------------------------------------------------------------------

lon    = [];
lat    = [];
x      = [];
y      = [];
excldx = [];
excldy = [];
barx   = [];
bary   = [];
trange = [];
relrng = [];

%-------------------------------------------------------------------------------
% Create plot.
%-------------------------------------------------------------------------------

image(sst);colormap(sstmap);
axis off;
set (gca,'DataAspectRatio',[1 1 1]);

%-------------------------------------------------------------------------------
% Get navigation data.
%-------------------------------------------------------------------------------

disp ('Locate first known position');

lat(1) = input ('   Latitude of first known position:   ');
lon(1) = input ('   Longitude of first known position:  ');
dum = input ('Zoom into area of first known position and hit return');
disp ('   Select first known position');
[x(1),y(1)] = ginput (1);

disp (' ');
dum = input ('Zoom out to full view and hit return');

disp (' ');
disp ('Locate second known position');

lat(2) = input ('   Latitude of second known position:   ');
lon(2) = input ('   Longitude of second known position:  ');
dum = input ('   Zoom into area of second known position and hit return');
disp ('   Select second known position');
[x(2),y(2)] = ginput (1);

disp (' ');
dum = input ('Zoom out to full view and hit return');

%-------------------------------------------------------------------------------
% Get position of colorbar.
%-------------------------------------------------------------------------------

disp (' ');
dum = input ('Zoom into area of color bar and hit return');

disp (' ');
disp ('Now, locate a box that fully encompasses the color bar.');
disp ('This will be used to eliminate the colorbar from the data.');

disp (' ');
disp ('   Select first corner of box');
[excldx(1),excldy(1)] = ginput (1);
disp ('   Select opposing corner of box');
[excldx(2),excldy(2)] = ginput (1);

disp (' ');
disp ('Now, locate a box that just encompasses the color bar.');
disp ('Select only the colored area, no white space or tick marks.');

set (gca,'XLim',extrem(excldx), ...
         'YLim',extrem(excldy));

disp (' ');
disp ('   Select first corner of box');
[barx(1),bary(1)] = ginput (1);
trange(1) = input ('   Enter temperature at this position:   ');
disp ('   Select opposing corner of box');
[barx(2),bary(2)] = ginput (1);
trange(2) = input ('   Enter temperature at this position:   ');

clear dum;

%-------------------------------------------------------------------------------
% Review data.
%-------------------------------------------------------------------------------

clf;
image(sst);colormap(sstmap);
axis off;
set (gca,'DataAspectRatio',[1 1 1]);

disp (' ');
disp ('Now, look at the SST image and decide what range of temperature');
disp ('values you trust.');

disp (' ');
T1 = input (['   Enter minimum reliable temperature [', ...
                    num2str(min(trange)),']: ']);
if isempty(T1)
   T1 = min(trange);
end;

disp (' ');
T2 = input (['   Enter maximum reliable temperature [', ...
                    num2str(max(trange)),']: ']);
if isempty(T2)
   T2 = max(trange);
end;

relrng = [T1 T2];

clear T1 T2;
