% sstgif2oa
%
% This script puts mapped SST data onto a HOPS OA(G)/FM netCDF file.

%-------------------------------------------------------------------------------
% Get run parameters.
%-------------------------------------------------------------------------------

%----------------------------
%--- Get input file name. ---
%----------------------------

[filename,pathname] = uigetfile ('*.in','Select parameter input file');

if (isstr(filename) & isstr(pathname))
   infile = fullfile (pathname,filename);
elseif isstr(filename)
   infile = filename;
else
   disp (' ');
   disp ('***Error:  SSTGIF2OA - unspecified input file');
   disp (' ');
   return;
end;

clear filename pathname

%----------------------------
%--- Read run parameters. ---
%----------------------------


[errmin,xpnddt,xpnder,combflg,ekfac,jdate,sstfile, ...
                                  frcfile,oafile]  = sstgif2oa_inparm (infile);

if isempty(oafile)
   disp (' ');
   disp ('***Error:  SSTGIF2OA - unable to read parameter input file:');
   disp (['           ',setstr(34),infile,setstr(34)]);
   return;
end;

clear infile

%-------------------------------------------------------------------------------
% Set useful parameters.
%-------------------------------------------------------------------------------

cm2m       = 0.01;

%-------------------------------------------------------------------------------
% Read in data.
%-------------------------------------------------------------------------------

%----------------
%--- Get SST. ---
%----------------

ann_tic ('Getting SST data.');

[lon,lat,temp,terr,tstd] = get_sst (errmin,xpnddt,xpnder,sstfile,oafile);

hms_toc

if isempty(terr),
   disp (' ');
   disp ('***Error:  SSTGIF2OA - unable to read SST file');
   disp(['           ',setstr(34),sstfile,setstr(34)]);
   disp (' ');
   return;
end;

%---------------------------
%--- Get surface fluxes. ---
%---------------------------

[HeatFlux,WindStress] = read_flx2 (frcfile,jdate);

if isempty(WindStress),
   disp (' ');
   disp ('***Error:  SSTGIF2OA - unable to read forcing file');
   disp(['           ',setstr(34),frcfile,setstr(34)]);
   disp (' ');
   return;
end;

%-------------------------------------------------------------------------------
% Construct mixed layer depths.
%-------------------------------------------------------------------------------

zmld  = ekfac.*WindStress.*cm2m;

%-------------------------------------------------------------------------------
% Place SST into OA(G)/FM file.
%-------------------------------------------------------------------------------

if (combflg)
   status = comb_oa (temp,terr,tstd,zmld,jdate,oafile);
 else
   status = rep_oa (temp,terr,tstd,zmld,jdate,oafile);
end;

if (status<0)
   disp (' ');
   disp ('***Error:  SSTGIF2OA - unable to place SST into OA(G)/FM file:');
   disp (['           ',setstr(34),oafile,setstr(34)]);
   return;
end;

clear oafile;
