function [errmin,xpnddt,xpnder,combflg,ekfac, ...
              jdate,sstfile,frcfile,oafile]  = sstgif2oa_inparm (infile);
%
% function [errmin,xpnddt,xpnder,combflg,ekfac, ...
%               jdate,sstfile,frcfile,oafile]  = sstgif2oa_inparm (infile);
%
% This function reads the parameters needed to map SST onto OA(G)/FM.

%-------------------------------------------------------------------------------
% Initialize output.
%-------------------------------------------------------------------------------

errmin  = [];
xpnddt  = [];
xpnder  = [];
smthrep = [];
ekfac   = [];
jdate   = [];
sstfile = '';
frcfile = '';
oafile  = '';

%-------------------------------------------------------------------------------
%  Open input file.
%-------------------------------------------------------------------------------

[fid,mess] = fopen (infile,'r');

if (fid<0)
   disp (' ');
   disp ('***Error:  SSTGIF2OA_INPARM - unable to open input file:');
   disp (['           ',setstr(34),infile,setstr(34)]);
   disp (['           ',setstr(34),mess,setstr(34)]);
   disp (' ');
   return;
end;

%-------------------------------------------------------------------------------
% Read input ASCII file.
%-------------------------------------------------------------------------------

errmin  = num_read (fid);
xpnddt  = num_read (fid);
xpnder  = num_read (fid);
combflg = num_read (fid);
ekfac   = num_read (fid);
jdate   = num_read (fid);

sstfile = fgetl (fid);
frcfile = fgetl (fid);
oafile  = fgetl (fid);

%-------------------------------------------------------------------------------
% Close input ASCII file.
%-------------------------------------------------------------------------------

status = fclose (fid);

if (status<0)
   disp (' ');
   disp ('***Error:  SSTGIF2OA_INPARM - unable to close input file:');
   disp (['           ',setstr(34),infile,setstr(34)]);
   disp (' ');
   return;
end;

clear fid status
