      subroutine xtrsubdom
c
c=======================================================================
c                                                                    ===
c  This routine extracts initial and boundary conditions data for    ===
c  the requested sub-domains.   The parameters for the extraction    ===
c  are read from file "extraction.dat".   This extraction package    ===
c  assumes that there is a  NetCDF file available for each domain    ===
c  which is generated by pre-processing program PE_INITIAL.          ===
c                                                                    ===
c  Input parameters for each sub-domain from file "extraction.dat":  ===
c                                                                    ===
c      NSUBDOM     number of sub-domains to extract                  ===
c      TSTR_XTR    starting extraction timestep                      ===
c      DT_XTR      extraction sampling rate in timestep units        ===
c      TEND_XTR    ending extraction timestep                        ===
c      XTR_NAME    input/output extraction NetCDF filename           ===
c                                                                    ===
c  Calls:                                                            ===
c                                                                    ===
c      EXITUS, XTRACT                                                ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fullwd.h>
#include <scalar.h>
#include <iounits.h>
#include <xtr_opts.h>
c
c-----------------------------------------------------------------------
c  Define local  data.
c-----------------------------------------------------------------------
c
      logical first
      integer n
      FLOAT
     *      tcurr
      save first
      data first /.true./
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  On the first call, read in extraction parameters.
c-----------------------------------------------------------------------
c
      if(first) then
        first=.false.
        open(xtrinp,file=xparnam,status='old',err=20)
        read(xtrinp,*,err=20) nsubdom
        do 10 n=1,nsubdom
          read(xtrinp,*,err=20) tstr_xtr(n),dt_xtr(n),tend_xtr(n)
          read(xtrinp,'(a)') xtr_name(n)
  10    continue
        close(xtrinp)
        goto 30
  20    continue
        write(stdout,900) xparnam
        call exitus('XTRSUBDOM')
  30    continue
      endif
c
c-----------------------------------------------------------------------
c  Retrieve, extract and interpolate initialization and boundary data
c  for each requested domain.
c-----------------------------------------------------------------------
c
      do 40 n=1,nsubdom
c
c  Process initialization data.
c
        if (itt.eq.tstr_xtr(n)) then
#ifndef resetjulian
          tcurr=dstart+(ttsec-dtts)*sec2day
#else
          tcurr=d0start+(ttsec-dtts)*sec2day
#endif
          tindx_xtr(n)=tindx_xtr(n)+1
          write(stdout,*) ' Begin extraction of data for domain = ',n,
     *                    ' at day = ',ttsec*sec2day
          call xtract(tcurr,0,tindx_xtr(n),xtr_name(n))
          tnext_xtr(n)=itt+dt_xtr(n)
c
c  Process boundary condition data.
c
        elseif (dt_xtr(n).gt.0) then
          if ((itt.eq.tnext_xtr(n)).and.(itt.le.tend_xtr(n))) then
            tindx_xtr(n)=tindx_xtr(n)+1
#ifndef resetjulian
            tcurr=dstart+(ttsec-dtts)*sec2day
#else
            tcurr=d0start+(ttsec-dtts)*sec2day
#endif
            call xtract(tcurr,1,tindx_xtr(n),xtr_name(n))
            tnext_xtr(n)=itt+dt_xtr(n)
            if (itt.eq.tend_xtr(n)) then
              write(stdout,*) ' End extraction of data for domain = ',n,
     *                        ' at day = ',ttsec*sec2day
            endif
          endif
        endif
 40   continue
c
 900  format(/' XTRSUBDOM - error while reading extraction parameters',
     *        ' from input file = ',a)
      return
      end
