       subroutine gregorian ( julian, id, mm, iyyy, iyday )
c      This routine converts  Julian Day number  to calendar date.  Here
c      JULIAN is input as the Julian day number, and outputs MM, ID, and
c      YYY as the month, day, and year on which the specified Julian Day
c      started at noon.
       integer igreg
       parameter ( igreg = 2299161 )
       integer  iyd(13), iydl(13)
       integer julian,iyday,jalpha,ja,jb,jc,jd,je,id,mm,iyyy,ileap
       data     iyd  /1,32,60,91,121,152,182,213,244,274,305,335,366/
       data     iydl /1,32,61,92,122,153,183,214,245,275,306,336,367/
       if ( julian .ge. igreg ) then
           jalpha = int ( ( ( julian -1867216 ) - 0.25 ) / 36524.25 )
           ja = julian + 1 + jalpha - int ( 0.25 * jalpha )
       else
           ja = julian
       endif
       jb = ja + 1524
       jc = int ( 6680. + ( ( jb - 2439870 ) -122.1 ) / 365.25 )
       jd = 365 * jc + int ( 0.25 * jc )
       je = int ( ( jb - jd ) / 30.6001 )
       id = jb - jd - int ( 30.6001 * je )
       mm = je - 1
       if ( mm .gt. 12 ) mm = mm - 12
       iyyy = jc - 4715
       if ( mm .gt. 2 ) iyyy = iyyy - 1
       if ( iyyy .le. 0 )iyyy = iyyy - 1
       ileap = mod ( iyyy, 4 )
       if ( ileap .eq. 0 ) then
           iyday = iydl(mm) + id - 1
       else
           iyday = iyd(mm) + id - 1
       end if
       return
       end

