	program mkflux3

c  calculates pemodel fluxes from FNOC data
c this assumes the 2-degree grid encompasses the 1-degree grid 
c note that longitudes will not be right if goes from positive to negative
c (fix this by just reading the first lon?)
c
# include <param.h>
c 
c  Larry Anderson, Feb 1997
c
c to do: check for other formulas, in Peixoto and Oort, and Picard & Emery
c to do: check to make sure all values seem reasonable!
c are the FNOC values instantaneous, or time averages? which use?
c
      integer    mxclm
      parameter (mxclm=5)
c
      real lat(ny+1),lon(nx),taux(nx,ny),tauy(nx,ny),u10m(nx,ny),
     &     pres(nx,ny),sst(nx,ny),evap(nx,ny),qnet(nx,ny),airt(nx,ny),
     &     emp(nx,ny),prcp(nx,ny),
     &     relh(nx3a:nx3b,ny3a:ny3b),cldc(nx3a:nx3b,ny3a:ny3b),
     &     swrd(nx3a:nx3b,ny3a:ny3b)
#ifdef makeclimo
     &     ,tclm(mxclm),mairt(nx,ny),mcldc(nx3a:nx3b,ny3a:ny3b),
     &      mprcp(nx,ny),mpres(nx,ny),mrelh(nx3a:nx3b,ny3a:ny3b),
     &      msst(nx,ny),mtaux(nx,ny),mtauy(nx,ny),mu10m(nx,ny)
#endif
      integer idir(nx,ny),ispd(nx,ny),inum
#ifdef makeclimo
     &        ,nclm
#endif
#ifdef sunfpe
     &             ,ieeer,my_handler,ieee_handler
#endif
#ifdef makeclimo
     &             ,nclm1,nclm2
#endif
      character*40 outfile1,outfile2,outfile3,outfile4,outfile5
      character*80 windfile,airtfile,relhfile,sstefile,presfile,
     &             prcpfile,cldcfile
      integer i,iheat,ndays,ij,id,im,iy,iyday,yearday,j,inum
      integer nptx,npty
      integer nxa,nxb,nya,nyb
      real cd,deg2rad,fac,pi,rair,time
c
#ifdef makeclimo
      parameter (nclm1=nx*ny, nclm2=(nx3b-nx3a+1)*(ny3b-ny3a+1))
c
#endif
#ifdef sunfpe
      external my_handler
c
#endif
#ifdef makeclimo
      data nclm /1/
      data tclm /4.0,11.0,18.0,25.0,32.0/
      data mairt,mprcp,mpres,msst,mtaux,mtauy,mu10m /nclm1*0.0,nclm1*0.0
     &                                             ,nclm1*0.0,nclm1*0.0,
     &                                    nclm1*0.0,nclm1*0.0,nclm1*0.0/
      data mcldc,mrelh /nclm2*0.0,nclm2*0.0/
     &      
c
#endif
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifdef sunfpe
c-----------------------------------------------------------------------
c     Enable floating point error flags.                               |
c-----------------------------------------------------------------------
c
      ieeer = ieee_handler ('set','common',my_handler)
      if (ieeer .ne. 0) write (6,900)
c
#endif
c      print *, 'enter ascii output filename'
         read *, i
         read *, outfile1
         open(20,file=outfile1)
c      name of output file for wind stress         (for input to peforcing)
         read *, i
         read *, outfile2
c      name of output file for net heat flux       (for input to peforcing)
         read *, i
         read *, outfile3
c      name of output file for surface water flux  (for input to peforcing)
         read *, i
         read *, outfile4
c      name of output file for shortwave radiation (for input to peforcing)
         read *, i
         read *, outfile5
c      flag to write heat flux components: [0]=no, [1]=yes
         read *, i
         read *, iheat
c      number of days to process
         read *, i
         read *, ndays
c
c define range for common 1 degree sub-grid
c
      nxa=max(1 ,nx3a)
      nxb=min(nx,nx3b)
      nya=max(1 ,ny3a)
      nyb=min(ny,ny3b)
c
c process one day at  time
c
      do inum=1,ndays
c
c        print *, 'enter modified Julian day to assign (integer)'
c        print *, '(4 Aug 1996 = 10300; 3 Sep 1996 = 10330; ',
c     &           '3 Oct 1996 = 10360)'
           read *, i
           read *, time
c        print *, 'enter pres file to read (e.g. a0181910.00t)'
           read *, i
           read 301, presfile
c        print *, 'enter airt file to read (e.g. a0781910.00t)'
           read *, i
           read 301, airtfile
c        print *, 'enter precip file to read (e.g. a6281910.00t)'
           read *, i
           read 301, prcpfile
c        print *, 'enter wind file to read (e.g. awg81910.00t)'
           read *, i
           read 301, windfile
c        print *, 'enter sst file to read (e.g. b1081910.00t or ',
c     &           'aci81910.00t)'
           read *, i
           read 301, sstefile
c        print *, 'enter relh file to read (e.g. c3481910.00t)'
           read *, i
           read 301, relhfile
c        print *, 'enter cloudc file to read (e.g. z1281910.00t)'
           read *, i
           read 301, cldcfile
 301    format(a)
c
c  find yearday
        ij=nint(time)+2440000
        call gregorian(ij,id,im,iy,iyday)
        yearday=real(iyday)
c
c yearday is round off to days
c
c  to do:  compute local fraction of day based on longitude and GMT time
c
c----------------------------------------------------------------------
c  compute wind stress
c----------------------------------------------------------------------
c
c read wind speed and direction
c
        call read3 (nx,ny,ispd,idir,windfile,lat,lon)
c
c constants (in MKS) are from Pond & Picard, p 108
c
	rair=1.3
        cd=.0014
        pi=3.1415927
        deg2rad=pi/180.
c
        call windstress (rair,cd,deg2rad,ispd,idir,taux,tauy,u10m)
#ifdef makeclimo
        call run_avg (1,nx,1,ny,ndays,taux,mtaux)
        call run_avg (1,nx,1,ny,ndays,tauy,mtauy)
        call run_avg (1,nx,1,ny,ndays,u10m,mu10m)
#endif
c
c----------------------------------------------------------------------
c  compute short wave radiation; from Peixoto and Oort, 1992, p 99
c----------------------------------------------------------------------
c
c read cloud cover
c
        call read2 (nx3a,nx3b,ny3a,ny3b,cldc,cldcfile,1)
c
c  Convert cloud cover to a fractional value.
c
        call cloud_scale (cldcfile,fac)
        call scale_fld (nx3a,nx3b,ny3a,ny3b,fac,cldc)
#ifdef makeclimo
        call run_avg (nx3a,nx3b,ny3a,ny3b,ndays,cldc,mcldc)
#endif
c
c  Compute shortwave radiation flux
c
        call shortwave (pi,deg2rad,yearday,lat,cldc,swrd)
c
c----------------------------------------------------------------------
c  compute net heat flux
c----------------------------------------------------------------------
c
c read air temperature
c
        call read1 (nx,ny,airt,airtfile,1)
#ifdef makeclimo
        call run_avg (1,nx,1,ny,ndays,airt,mairt)
#endif
c
c read relative humidity
c
        call read2 (nx3a,nx3b,ny3a,ny3b,relh,relhfile,2)
#ifdef makeclimo
        call run_avg (nx3a,nx3b,ny3a,ny3b,ndays,relh,mrelh)
#endif
c
c read sea surface temperature
c
        call read1 (nx,ny,sst,sstefile,1)
#ifdef makeclimo
        call run_avg (1,nx,1,ny,ndays,sst,msst)
#endif
c
c read surface pressure
c
        call read1 (nx,ny,pres,presfile,1)
#ifdef makeclimo
        call run_avg (1,nx,1,ny,ndays,pres,mpres)
#endif
c
c  Compute net head flux
c
        call net_heat (nxa,nxb,nya,nyb,swrd,u10m,airt,relh,sst,pres,
     &                 cldc,qnet,evap)
c
c----------------------------------------------------------------------
c  compute evaporation minus precipitation
c----------------------------------------------------------------------
c
c read precipitation
c
        call read1(nx,ny,prcp,prcpfile,2)
c
c convert from 10ths of inches in 12 hours to cm/day
c
        fac=0.1*2.54*2.
        call scale_fld (1,nx,1,ny,fac,prcp)
#ifdef makeclimo
        call run_avg (1,nx,1,ny,ndays,prcp,mprcp)
#endif
c
        call evap_precip (evap,prcp,emp)
c
c---------------------------------------------------------------------- 
c  write components
c----------------------------------------------------------------------
c
        if (inum.eq.1) then
c
c open files and write headers
c
          nptx=nxb-nxa+1
          npty=nyb-nya+1
          open(21,file=outfile2)
#ifndef makeclimo
            write(21,*) ndays,nptx,npty
#else
            write(21,*) ndays+nclm,nptx,npty
#endif
            write(21,*) (lon(i),i=nxa,nxb)
            write(21,*) (lat(j),j=nya,nyb)
          open(22,file=outfile3)
#ifndef makeclimo
            write(22,*) ndays,nptx,npty
#else
            write(22,*) ndays+nclm,nptx,npty
#endif
            write(22,*) (lon(i),i=nxa,nxb)
            write(22,*) (lat(j),j=nya,nyb)
          open(23,file=outfile4)
#ifndef makeclimo
            write(23,*) ndays,nptx,npty
#else
            write(23,*) ndays+nclm,nptx,npty
#endif
            write(23,*) (lon(i),i=nxa,nxb)
            write(23,*) (lat(j),j=nya,nyb)
          open(24,file=outfile5)
#ifndef makeclimo
            write(24,*) ndays,nptx,npty
#else
            write(24,*) ndays+nclm,nptx,npty
#endif
            write(24,*) (lon(i),i=nxa,nxb)
            write(24,*) (lat(j),j=nya,nyb)
        endif
c wind stress
        write(21,*) time
        write(21,*) ((taux(i,j),i=nxa,nxb),j=nya,nyb)
        write(21,*) time
        write(21,*) ((tauy(i,j),i=nxa,nxb),j=nya,nyb)
c heat flux 
        write(22,*) time
        write(22,*) ((qnet(i,j),i=nxa,nxb),j=nya,nyb)
c evaporation minus precipitation
        write(23,*) time
        write(23,*) ((emp(i,j),i=nxa,nxb),j=nya,nyb)
c shortwave radiation 
        write(24,*) time
        write(24,*) ((swrd(i,j),i=nxa,nxb),j=nya,nyb)
      enddo
c
#ifdef makeclimo
      do inum = 1, nclm
c wind stress
         write(21,*) time+tclm(inum)
         write(21,*) ((mtaux(i,j),i=nxa,nxb),j=nya,nyb)
         write(21,*) time+tclm(inum)
         write(21,*) ((mtauy(i,j),i=nxa,nxb),j=nya,nyb)
c shortwave radiation 
         ij=nint(time)+tclm(inum)+2440000
         call gregorian(ij,id,im,iy,iyday)
         yearday=real(iyday)
         call shortwave (pi,deg2rad,yearday,lat,mcldc,swrd)
         write(24,*) time+tclm(inum)
         write(24,*) ((swrd(i,j),i=nxa,nxb),j=nya,nyb)
c heat flux 
         call net_heat (nxa,nxb,nya,nyb,swrd,mu10m,mairt,mrelh,msst,
     &                  mpres,mcldc,qnet,evap)
         write(22,*) time+tclm(inum)
         write(22,*) ((qnet(i,j),i=nxa,nxb),j=nya,nyb)
c evaporation minus precipitation
         call evap_precip (evap,mprcp,emp)
         write(23,*) time+tclm(inum)
         write(23,*) ((emp(i,j),i=nxa,nxb),j=nya,nyb)
      enddo
c
#endif
      close(20)
      close(21) 
      close(22) 
      close(23) 
      close(24) 
c
      stop
#ifdef sunfpe
 900  format (/'+++ Warning:  ieee_handler cannot set my_handler'/)
#endif
      end


