      subroutine run_avg (ibgn,iend,jbgn,jend,nday,fld,mfld)
c
c=======================================================================
c                                                                    ===
c  This routine updates a running average of a field.                ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     IBGN   Starting leading index.                (integer)        ===
c     IEND   Ending leading index.                  (integer)        ===
c     JBGN   Starting second index.                 (integer)        ===
c     JEND   Ending second index.                   (integer)        ===
c     NDAY   Number of fields.                      (integer)        ===
c     FLD    Current field.                         (real array)     ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     MFLD   Updated value of mean field.           (real array)     ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ibgn,iend,j,jbgn,jend,nday
      real    fac
      real    fld(ibgn:iend,jbgn:jend),mfld(ibgn:iend,jbgn:jend)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      fac = 1.0/float(nday)
c
      do 10 j = jbgn, jend
      do 10 i = ibgn, iend
         mfld(i,j) = mfld(i,j) + fac*fld(i,j)
  10  continue
c
      return
      end
