      subroutine windstress (rair,cd,deg2rad,ispd,idir,taux,tauy,u10m)
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
# include <param.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j
      integer idir(nx,ny),ispd(nx,ny)
      real    cd,deg2rad,rair,velx,vely
      real taux(nx,ny),tauy(nx,ny),u10m(nx,ny)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c----------------------------------------------------------------------
c  compute wind stress
c----------------------------------------------------------------------
c
c now convert wind speed (knots) and direction into
c x- and y- wind stress (dynes/cm2) ; 1 knot = .514 m/s (Pond & Picard)
c velx,vely are in m/s ; taux,tauy are in dynes/cm2
c nodds dir is 0 heading south, 90 heading west
c
	do i=1,nx
        do j=1,ny
          u10m(i,j)=.514*real(ispd(i,j))
          velx=-u10m(i,j)*sin(real(idir(i,j))*deg2rad)
          vely=-u10m(i,j)*cos(real(idir(i,j))*deg2rad) 
#ifndef revstress
          taux(i,j)=10.*sign(rair*cd*velx*velx, velx)
          tauy(i,j)=10.*sign(rair*cd*vely*vely, vely)
#else
          taux(i,j)=10.*rair*cd*u10m(i,j)*velx
          tauy(i,j)=10.*rair*cd*u10m(i,j)*vely
#endif
	enddo
	enddo
c
      return
      end
