      subroutine cloud_scale (cldfile,scale)
c
c=======================================================================
c                                                                    ===
c  This routine determines the scaling to be applied to the cloud    ===
c  cover.                                                            ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     CLDFILE   Name of input cloud data file.   (string)            ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     SCALE     Cloud scaling factor.            (real)              ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      real    scale
      integer       idate,iptr
      character*(*) cldfile
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifndef guesscloud
c-----------------------------------------------------------------------
c  convert to fraction; file header says it is in percent, but it looks
c  like it is actually in 10ths
c-----------------------------------------------------------------------
c
      scale = 0.1
c
# else
c-----------------------------------------------------------------------
c  A change seems to have taken place at the March 15, 2000 1200Z
c  FNMOC issuance.  Prior to that time the cloud cover seemed to
c  be in tenths.  From that time on, the cloud cover looks to be
c  in thousandths.
c-----------------------------------------------------------------------
c
      iptr = index (cldfile,'Z12')
      read (cldfile((iptr+3):(iptr+7)),'(i5)') idate
c
      if (idate.lt.31510) then
         scale = 0.1
       else
         scale = 0.001
      end if
c
#endif
      return
      end
