	program mkflux2

c  calculates pemodel fluxes from FNOC data
c this assumes the 2-degree grid encompasses the 1-degree grid 
c note that longitudes will not be right if goes from positive to negative
c (fix this by just reading the first lon?)
# include <param.h>
c 
c  Larry Anderson, Feb 1997

c to do: check for other formulas, in Peixoto and Oort, and Picard & Emery
c to do: check to make sure all values seem reasonable!
c are the FNOC values instantaneous, or time averages? which use?

      real ch,ce,sigma,eps,rgcon
      parameter(ch=0.83e-3,ce=1.5e-3,sigma=5.67e-8)
      parameter(eps=0.62197,rgcon=287.04)
 
c ch is the Stanton number (dimensionless)
c ce is the Dalton number (dimensionless) 
c sigma is Stefan-Boltzmann constant (W m-2 K-4)
c eps is a constant from Gill p 41 3.1.13
c rgcon is the universal gas constant; Gill p 40 3.1.3

      real lat(ny+1),lon(nx),taux(nx,ny),tauy(nx,ny),u10m(nx,ny),
     &     pres(nx,ny),sst(nx,ny),evap(nx,ny),qnet(nx,ny),airt(nx,ny),
     &     emp(nx,ny),hlat(nx,ny),hsens(nx,ny),hback(nx,ny),prcp(nx,ny),
     &     relh(nx3a:nx3b,ny3a:ny3b),cldc(nx3a:nx3b,ny3a:ny3b),
     &     swrd(nx3a:nx3b,ny3a:ny3b)
#ifdef makeclimo
     &     ,rndays,trlx,mtaux(nx,ny),mtauy(nx,ny),memp(nx,ny),
     &     mqnet(nx,ny),mswrd(nx3a:nx3b,ny3a:ny3b)
#endif
#ifdef guesscloud
     &     ,cloudmax,cldscl
#endif
      integer idir(nx,ny),ispd(nx,ny),inum
#ifdef sunfpe
     &             ,ieeer,my_handler,ieee_handler
#endif
#ifdef makeclimo
     &             ,nclm1,nclm2
#endif
#ifdef guesscloud
     &             ,cldpwr
#endif
      character*40 outfile1,outfile2,outfile3,outfile4,outfile5
      character*80 windfile,airtfile,relhfile,sstefile,presfile,
     &             prcpfile,cldcfile
      integer i,iheat,ndays,ij,id,im,iy,iyday,yearday,j,inum
      integer nptx,npty
      integer nxa,nxb,nya,nyb
      real time,rair,cd,pi,deg2rad,velx,vely,s0,xlat,decl,fd,x,h,swrad
      real esat,qsat,qa,airtv,rhoair,ea,cpair,vl,fac
c
#ifdef makeclimo
      parameter (nclm1=nx*ny, nclm2=(nx3b-nx3a+1)*(ny3b-ny3a+1))
c
#endif
#ifdef sunfpe
      external my_handler
c
#endif
#ifdef makeclimo
      data mtaux,mtauy,memp,mqnet /nclm1*0.0,nclm1*0.0,nclm1*0.0,
     &                             nclm1*0.0/
      data mswrd /nclm2*0.0/
      data trlx /4.0/
c
#endif
#ifdef sunfpe
c-----------------------------------------------------------------------
c     Enable floating point error flags.                               |
c-----------------------------------------------------------------------
c
      ieeer = ieee_handler ('set','common',my_handler)
      if (ieeer .ne. 0) write (6,900)
c
#endif
c      print *, 'enter ascii output filename'
         read *, i
         read *, outfile1
         open(20,file=outfile1)
c      name of output file for wind stress         (for input to peforcing)
         read *, i
         read *, outfile2
c      name of output file for net heat flux       (for input to peforcing)
         read *, i
         read *, outfile3
c      name of output file for surface water flux  (for input to peforcing)
         read *, i
         read *, outfile4
c      name of output file for shortwave radiation (for input to peforcing)
         read *, i
         read *, outfile5
c      flag to write heat flux components: [0]=no, [1]=yes
         read *, i
         read *, iheat
c      number of days to process
         read *, i
         read *, ndays
c
c define range for common 1 degree sub-grid
c
#ifdef makeclimo
      rndays = 1.0/float(ndays)
#endif
      nxa=max(1 ,nx3a)
      nxb=min(nx,nx3b)
      nya=max(1 ,ny3a)
      nyb=min(ny,ny3b)
c
c process one day at  time
c
      do inum=1,ndays
        
c        print *, 'enter modified Julian day to assign (integer)'
c        print *, '(4 Aug 1996 = 10300; 3 Sep 1996 = 10330; ',
c     &           '3 Oct 1996 = 10360)'
           read *, i
           read *, time
c        print *, 'enter pres file to read (e.g. a0181910.00t)'
           read *, i
           read 301, presfile
c        print *, 'enter airt file to read (e.g. a0781910.00t)'
           read *, i
           read 301, airtfile
c        print *, 'enter precip file to read (e.g. a6281910.00t)'
           read *, i
           read 301, prcpfile
c        print *, 'enter wind file to read (e.g. awg81910.00t)'
           read *, i
           read 301, windfile
c        print *, 'enter sst file to read (e.g. b1081910.00t or ',
c     &           'aci81910.00t)'
           read *, i
           read 301, sstefile
c        print *, 'enter relh file to read (e.g. c3481910.00t)'
           read *, i
           read 301, relhfile
c        print *, 'enter cloudc file to read (e.g. z1281910.00t)'
           read *, i
           read 301, cldcfile
 301    format(a)
        
c  find yearday
        ij=nint(time)+2440000
        call gregorian(ij,id,im,iy,iyday)
        yearday=real(iyday)
cjl
c yearday is round off to days

c  to do:  compute local fraction of day based on longitude and GMT time

c----------------------------------------------------------------------
c  compute wind stress
c----------------------------------------------------------------------
claac read wind speed and direction
        call read3(nx,ny,ispd,idir,windfile,lat,lon)
c constants (in MKS) are from Pond & Picard, p 108
	rair=1.3
        cd=.0014
        pi=3.1415927
        deg2rad=pi/180.
c now convert wind speed (knots) and direction into
c x- and y- wind stress (dynes/cm2) ; 1 knot = .514 m/s (Pond & Picard)
c velx,vely are in m/s ; taux,tauy are in dynes/cm2
c nodds dir is 0 heading south, 90 heading west
	do i=1,nx
        do j=1,ny
          u10m(i,j)=.514*real(ispd(i,j))
          velx=-u10m(i,j)*sin(real(idir(i,j))*deg2rad)
          vely=-u10m(i,j)*cos(real(idir(i,j))*deg2rad) 
          taux(i,j)=10.*sign(rair*cd*velx*velx, velx)
          tauy(i,j)=10.*sign(rair*cd*vely*vely, vely)
	enddo
	enddo
       
c----------------------------------------------------------------------
c  compute short wave radiation; from Peixoto and Oort, 1992, p 99
c----------------------------------------------------------------------
c read cloud cover
        call read2(nx3a,nx3b,ny3a,ny3b,cldc,cldcfile,1)
c convert to fraction; file header says it is in percent, but it looks
c  like it is actually in 10ths
#ifndef guesscloud
        do i=nx3a,nx3b
        do j=ny3a,ny3b
          cldc(i,j)=0.1*cldc(i,j)
        enddo
        enddo
#else
        cloudmax = 0.0
        do i=nx3a,nx3b
        do j=ny3a,ny3b
          cloudmax = max(cloudmax, cldc(i,j))
        enddo
        enddo
        if (cloudmax.gt.0.0) then
           cldpwr = int(log10(cloudmax))+1
           cldscl = 10.0**(-float(cldpwr))
           do i=nx3a,nx3b
           do j=ny3a,ny3b
             cldc(i,j)=cldscl*cldc(i,j)
           enddo
           enddo
        end if
#endif
c
c   s0 is the solar constant in W/m2
        s0 = 1360.
        do j=ny3a,ny3b
          xlat = lat(min(max(j,1),(ny+1)))
          xlat = max(min(89.,xlat),-89.)*deg2rad
c   decl is declination in radians, assuming -23.45 on Dec 21
          decl = -23.45*cos(2.*pi*(355.-yearday)/365.)*deg2rad
c   approx effect of Sun-earth distance, assuming closest on Jan 6
          fd = 1. + .035*cos(2.*pi*(6.-yearday)/365.)
c   compute daily integrated flux in W m-2 day
          x = -1.* tan(xlat)*tan(decl)
          x = max(min(1.,x),-1.)
          h = acos(x)
          swrad = (24./pi)*s0*fd*
     &            (h*sin(xlat)*sin(decl)+cos(xlat)*cos(decl)*sin(h))
          swrad = max(0.,swrad)
c   for some reason, swrad needs to be divided by 24
c   to get average daily flux in W/m2
          swrad = swrad/24.
c   now assume cloud-free atmospheric absorption and reflection (including 
c   reflection at the sea surface) gives a mean transmission of 76%:
c   (Pond and Picard say 70%; Peixoto and Oort say 76%; for a mean cloud 
c   cover of 50%, 76% cloud-free transmission gives 49% total transmission)
          swrad = swrad*0.76
c   now take into account effect of local cloud cover
          do i=nx3a,nx3b
            swrd(i,j)=swrad*(1.-0.7*cldc(i,j))
          enddo
        enddo
     
c  to do: swrad can be made more complex, i.e. for absorption and refelction
c         to depend on angle, humidity, and skylight; but it seems ok for now

c----------------------------------------------------------------------
c  compute net heat flux
c----------------------------------------------------------------------
c read air temperature
        call read1(nx,ny,airt,airtfile,1)
c read relative humidity
        call read2(nx3a,nx3b,ny3a,ny3b,relh,relhfile,2)
c read sea surface temperature
        call read1(nx,ny,sst,sstefile,1)
c read surface pressure
        call read1(nx,ny,pres,presfile,1)
c esat is the saturation vapor pressure (mb); Gill p 606 (A4.5)
c qsat is the saturation specific humidity (nondim); Gill p 605 (A4.3)
c qa is specific humidity (nondimensional); Gill p 605 (A4.4)
c airtv is the virtual air temperature (K); Gill p 41 (3.1.15)
c rhoair is air density (kg m-3); Gill p 41 (3.1.14)
c ea is vapor pressure (mb); Gill p 605 (A4.3)
c cpair is specific heat of moist air from Gill p 43, eq 3.3.3
c vl is latent heat of evaporation (J kg-1); Gill p 607 (A4.9)

        do j=nya,nyb
        do i=nxa,nxb
          esat=10.**((0.7859+0.03477*airt(i,j))/(1.+0.00412*airt(i,j)))
          qsat=(eps*esat/pres(i,j))/(1.-(1.-eps)*esat/pres(i,j))
          relh(i,j) = relh(i,j)/100. 
          qa = relh(i,j)*qsat/(1.-qsat+qsat*relh(i,j))
          airtv=(273.+airt(i,j))*(1.+0.6078*qa)  
          rhoair=100.*pres(i,j)/(rgcon*airtv)
          ea=pres(i,j)*qa/(eps+(1.-eps)*qa) 
          cpair = 1004.6*(1.+0.8375*qa) 
          vl = (2.5008e+6) - (2.3e+3)*airt(i,j)
      
c sensible heat flux in W m-2 from Gill p 30
          hsens(i,j) = cpair*rhoair*ch*u10m(i,j)*(airt(i,j)-sst(i,j))
         
c latent heat flux in W m-2 from Gill p 30; evap is in kg m-2 sec-1
          evap(i,j) = rhoair*ce*u10m(i,j)*(qsat-qa)
          hlat(i,j) = -evap(i,j)*vl
         
c longwave radiation in W/m2; Gill p 34 (eq. 2.6.2)
          hback(i,j) = -0.985*sigma*((sst(i,j) + 273.)**4) *
     &            (0.39-0.05*sqrt(ea))*(1.-0.6*cldc(i,j)*cldc(i,j))

          qnet(i,j) = swrd(i,j) + hsens(i,j) + hlat(i,j) + hback(i,j)
        enddo
        enddo

c----------------------------------------------------------------------
c  compute evaporation minus precipitation
c----------------------------------------------------------------------
c read precipitation
        call read1(nx,ny,prcp,prcpfile,2)
c convert from 10ths of inches in 12 hours to cm/day
        fac=0.1*2.54*2.
        do j=1,ny
        do i=1,nx
          prcp(i,j) = prcp(i,j)*fac
        enddo
        enddo

c      convert evaporation from kg m-2 sec-1 to cm/day
        fac = 100.*86400./1025.
        do j=1,ny
        do i=1,nx
          evap(i,j) = evap(i,j)*fac
          emp(i,j) = evap(i,j) - prcp(i,j)
        enddo 
        enddo
c---------------------------------------------------------------------- 
c  write components
c----------------------------------------------------------------------
        if (inum.eq.1) then
c
c open files and write headers
c
          nptx=nxb-nxa+1
          npty=nyb-nya+1
          open(21,file=outfile2)
#ifndef makeclimo
            write(21,*) ndays,nptx,npty
#else
            write(21,*) ndays+1,nptx,npty
#endif
            write(21,*) (lon(i),i=nxa,nxb)
            write(21,*) (lat(j),j=nya,nyb)
          open(22,file=outfile3)
#ifndef makeclimo
            write(22,*) ndays,nptx,npty
#else
            write(22,*) ndays+1,nptx,npty
#endif
            write(22,*) (lon(i),i=nxa,nxb)
            write(22,*) (lat(j),j=nya,nyb)
          open(23,file=outfile4)
#ifndef makeclimo
            write(23,*) ndays,nptx,npty
#else
            write(23,*) ndays+1,nptx,npty
#endif
            write(23,*) (lon(i),i=nxa,nxb)
            write(23,*) (lat(j),j=nya,nyb)
          open(24,file=outfile5)
#ifndef makeclimo
            write(24,*) ndays,nptx,npty
#else
            write(24,*) ndays+1,nptx,npty
#endif
            write(24,*) (lon(i),i=nxa,nxb)
            write(24,*) (lat(j),j=nya,nyb)
        endif
c wind stress
        write(21,*) time
        write(21,*) ((taux(i,j),i=nxa,nxb),j=nya,nyb)
        write(21,*) time
        write(21,*) ((tauy(i,j),i=nxa,nxb),j=nya,nyb)
c heat flux 
        write(22,*) time
        write(22,*) ((qnet(i,j),i=nxa,nxb),j=nya,nyb)
c evaporation minus precipitation
        write(23,*) time
        write(23,*) ((emp(i,j),i=nxa,nxb),j=nya,nyb)
c shortwave radiation 
        write(24,*) time
        write(24,*) ((swrd(i,j),i=nxa,nxb),j=nya,nyb)
#ifdef makeclimo
        do j = nya, nyb
        do i = nxa, nxb
           mtaux(i,j) = mtaux(i,j) + rndays*taux(i,j)
           mtauy(i,j) = mtauy(i,j) + rndays*tauy(i,j)
           mqnet(i,j) = mqnet(i,j) + rndays*qnet(i,j)
           memp(i,j)  = memp(i,j) + rndays*emp(i,j)
           mswrd(i,j) = mswrd(i,j) + rndays*swrd(i,j)
        enddo
        enddo
#endif
      enddo
c
#ifdef makeclimo
c wind stress
      write(21,*) time+trlx
      write(21,*) ((mtaux(i,j),i=nxa,nxb),j=nya,nyb)
      write(21,*) time+trlx
      write(21,*) ((mtauy(i,j),i=nxa,nxb),j=nya,nyb)
c heat flux 
      write(22,*) time+trlx
      write(22,*) ((mqnet(i,j),i=nxa,nxb),j=nya,nyb)
c evaporation minus precipitation
      write(23,*) time+trlx
      write(23,*) ((memp(i,j),i=nxa,nxb),j=nya,nyb)
c shortwave radiation 
      write(24,*) time+trlx
      write(24,*) ((mswrd(i,j),i=nxa,nxb),j=nya,nyb)
c
#endif
      close(20)
      close(21) 
      close(22) 
      close(23) 
      close(24) 
c
      stop
#ifdef sunfpe
 900  format (/'+++ Warning:  ieee_handler cannot set my_handler'/)
#endif
      end


