      subroutine net_heat (nxa,nxb,nya,nyb,swrd,u10m,airt,relh,sst,pres,
     &                     cldc,qnet,evap)
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
# include <param.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
c ch is the Stanton number (dimensionless)
c ce is the Dalton number (dimensionless) 
c sigma is Stefan-Boltzmann constant (W m-2 K-4)
c eps is a constant from Gill p 41 3.1.13
c rgcon is the universal gas constant; Gill p 40 3.1.3
c
      real ch,ce,sigma,eps,rgcon
      parameter(ch=0.83e-3,ce=1.5e-3,sigma=5.67e-8)
      parameter(eps=0.62197,rgcon=287.04)
c
      integer i,j,nxa,nxb,nya,nyb
      real airtv,cpair,ea,esat,qsat,qa,rhoair,vl
      real airt(nx,ny),cldc(nx3a:nx3b,ny3a:ny3b),evap(nx,ny),
     &     hback(nx,ny),hlat(nx,ny),hsens(nx,ny),pres(nx,ny),qnet(nx,ny)
     &   ,relh(nx3a:nx3b,ny3a:ny3b),sst(nx,ny),swrd(nx3a:nx3b,ny3a:ny3b)
     &    ,u10m(nx,ny)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c esat is the saturation vapor pressure (mb); Gill p 606 (A4.5)
c qsat is the saturation specific humidity (nondim); Gill p 605 (A4.3)
c qa is specific humidity (nondimensional); Gill p 605 (A4.4)
c airtv is the virtual air temperature (K); Gill p 41 (3.1.15)
c rhoair is air density (kg m-3); Gill p 41 (3.1.14)
c ea is vapor pressure (mb); Gill p 605 (A4.3)
c cpair is specific heat of moist air from Gill p 43, eq 3.3.3
c vl is latent heat of evaporation (J kg-1); Gill p 607 (A4.9)
c
        do j=nya,nyb
        do i=nxa,nxb
          esat=10.**((0.7859+0.03477*airt(i,j))/(1.+0.00412*airt(i,j)))
          qsat=(eps*esat/pres(i,j))/(1.-(1.-eps)*esat/pres(i,j))
          relh(i,j) = relh(i,j)/100. 
          qa = relh(i,j)*qsat/(1.-qsat+qsat*relh(i,j))
          airtv=(273.+airt(i,j))*(1.+0.6078*qa)  
          rhoair=100.*pres(i,j)/(rgcon*airtv)
          ea=pres(i,j)*qa/(eps+(1.-eps)*qa) 
          cpair = 1004.6*(1.+0.8375*qa) 
          vl = (2.5008e+6) - (2.3e+3)*airt(i,j)
      
c sensible heat flux in W m-2 from Gill p 30
          hsens(i,j) = cpair*rhoair*ch*u10m(i,j)*(airt(i,j)-sst(i,j))
         
c latent heat flux in W m-2 from Gill p 30; evap is in kg m-2 sec-1
          evap(i,j) = rhoair*ce*u10m(i,j)*(qsat-qa)
          hlat(i,j) = -evap(i,j)*vl
         
c longwave radiation in W/m2; Gill p 34 (eq. 2.6.2)
          hback(i,j) = -0.985*sigma*((sst(i,j) + 273.)**4) *
     &            (0.39-0.05*sqrt(ea))*(1.-0.6*cldc(i,j)*cldc(i,j))

          qnet(i,j) = swrd(i,j) + hsens(i,j) + hlat(i,j) + hback(i,j)
        enddo
        enddo
c
      return
      end
