      subroutine shortwave (pi,deg2rad,yearday,lat,cldc,swrd)
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
# include <param.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j,yearday
      real pi,deg2rad,s0,xlat,decl,fd,x,h,swrad
      real lat(ny+1),cldc(nx3a:nx3b,ny3a:ny3b),
     &     swrd(nx3a:nx3b,ny3a:ny3b)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c   s0 is the solar constant in W/m2
        s0 = 1360.
        do j=ny3a,ny3b
          xlat = lat(min(max(j,1),(ny+1)))
          xlat = max(min(89.,xlat),-89.)*deg2rad
c   decl is declination in radians, assuming -23.45 on Dec 21
          decl = -23.45*cos(2.*pi*(355.-yearday)/365.)*deg2rad
c   approx effect of Sun-earth distance, assuming closest on Jan 6
          fd = 1. + .035*cos(2.*pi*(6.-yearday)/365.)
c   compute daily integrated flux in W m-2 day
          x = -1.* tan(xlat)*tan(decl)
          x = max(min(1.,x),-1.)
          h = acos(x)
          swrad = (24./pi)*s0*fd*
     &            (h*sin(xlat)*sin(decl)+cos(xlat)*cos(decl)*sin(h))
          swrad = max(0.,swrad)
c   for some reason, swrad needs to be divided by 24
c   to get average daily flux in W/m2
          swrad = swrad/24.
c   now assume cloud-free atmospheric absorption and reflection (including 
c   reflection at the sea surface) gives a mean transmission of 76%:
c   (Pond and Picard say 70%; Peixoto and Oort say 76%; for a mean cloud 
c   cover of 50%, 76% cloud-free transmission gives 49% total transmission)
          swrad = swrad*0.76
c   now take into account effect of local cloud cover
          do i=nx3a,nx3b
            swrd(i,j)=swrad*(1.-0.7*cldc(i,j))
          enddo
        enddo
c
      return
      end
