$ set noverify
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!                                                                        !
$!  VAX VMS Script to compile and link the PE MODEL.  Use the following   !
$!  command:                                                              !
$!                @ VMSmakefile                                           !
$!                                                                        !
$!                                      Patrick J. Haley Jr.   08/21/2001 !
$!                                      PE model version       9.6        !
$!                                                                        !
$! C-preprocessing options:                                               !
$!                                                                        !
$!  advtide         Add tidal advection to tracer eqns. (only with ext_tide).
$!  advtide0        Scale down tidal advection. (only with ext_tide & advtide)
$!  aixdate         AIX intrinsic date routine (IBM RS6000).
$!  analytical      Analytical initial and boundary fields.  (Do not use
$!                    with both "dblprec" and "forcing" also active)
$!  barotropic      barotropic model configuration (one level, KM=1)
$!  bioadjvert      Adjustment of biology using vertical dynamics only
$!  bioAnder        Anderson expansion of McGillicuddy biological model
$!  bioDuse         Dusenberry bio-optical models.
$!  bioFasham       Fasham et al. (1990) biological model
$!  bioMcGillic     McGillicuddy et al. (1995) biological model
$!  bndy_rlx        Boundary relaxation.
$!  botfrc          Bottom friction.
$!  close_tracers   Impose closed BCs on tracer N & S boundaries.
$!  coast           Coastal boundary conditions
$!  coastedge       Next to mask, average unmasked values (control noise)
$!  craydate        CRAY's intrisic date/time functions
$!  cstfrc          Coastal friction.
$!  cubspl          Vertical cubic spline interpolation by slabs
$!  cyclic          Cyclic (west/east) boundary conditions
$!  dblprec         Double precision floating-point operations and output
$!                    (Do not use with both "analytical" and "forcing" also
$!                    active)
$!  dblsigma        Double "sigma" transformation in the vertical
$!  decdate         DEC's intrisic date/time functions
$!  dusDroop        Droop nutrient limitation equations
$!  explicitvmix    Explicit vertical mixing
$!  ext_tide        Enable tidal forcing, read and manage barotropic tide info.
$!  extraction      Extract initial and boundary data for requested sub-domains
$!  fcsterr         Maintain OI forecast errors.  (with "oias")
$!  forcing         space/time variable forcing.  (Do not use with both
$!                    "analytical" and "dblprec" also active)
$!  frozentrc       Initially freeze tracers for specified number of timesteps
$!  gendbg          Generic Debugging:  Preserves intermediate files
$!  grids           Domain configuration from GRIDS NetCDF file
$!  hpg4            Forth order hydrostatic pressure gradient
$!  imp_bnd_rlx     Use semi-implicit in time scheme for boundary relaxation.
$!  islands         Islands are present in the model basin
$!  ldrifters       Lagrangian Drifters option
$!  leqstate        Linear Equation of State
$!  linear_physics  Linear physics: no adv mom, only vert. adv mean tracers
$!  mixtide         Add tide/turbulence interactions in vertical mixing
$!                    coefficient. (only with ext_tide)
$!  nestnultest     Create "nested" code without the nesting routines?
$!  nocfl           No CFL checking.
$!  notadvm         Linear Momentum Equation: no horizontal advection
$!  notadvt         Linear Heat Equation: no horizontal advection
$!  nowcfl          Disable CFL checking in the vertical.
$!  noxtrp          No extrapolation in hydrostatic pressure gradient
$!  oias            Intermittent OI assimilation option
$!  peprf           Hydrographic PE profiles
$!  ppvmix          Pacanowski and Philander vertical mixing scheme
$!  pressbias       Remove bias from pressure gradient
$!  pressinbias     Initialize bias file
$!  pttrcsrc        specification of point tracer sources
$!  resetjulian     Start surface forcing clock from supplied value.
$!  rmcomments      Remove all commented lines after C-preprocessing
$!  rmdenbar        Remove mean density when computing the pressure gradient
$!  rmdocinc        Remove documentation in all include files.
$!  secondmean      enforce zero mean internal vel. after Shapiro filter
$!  shapiro         Shapiro filter for horizontal viscosity
$!  shapmean        Remove "mean" tracer field before shapiro filtering
$!  simpramp        Simple ramping scheme.  (with "oias" and "fcsterr")
$!  sor5pt          transport solution via sequential over-relaxation
$!  sundate         SUN's intrisic date/time function
$!  sunflush        regularly flush output buffers in SUN systems.
$!  sunfpe          SUN's floating point exception trap
$!  unesco          Unesco (1980) nonlinear equation of state for seawater
$!  usrdiagnostic   Report user defined diagnostics.
$!  vbart           Vertical Simpson's integration in pressure gradient
$!  vel_conv        Require convergence in velocity when solving PBAR
$!  wgterr          An intuitive form of the OI ramping weight.  (with "oias")
$!
$!  New/testing
$!
$!  add_tide        On output, tidal velocity added to total velocity.
$!  bio_12_A        Additional productivity terms (bacterial, zooplankton, etc)
$!  bioadjloc       pseudo local biological adjustment.  Vertical diffusion
$!                    is on, but advection is off.
$!  bottom          Second-order in time bottom stress calculation.
$!  codunlim        Append cod model with unlimited response to T & zoo
$!  codlim          Append cod model with limited response to T & zoo
$!  codvadvect      Allow cod to be vertically advected.
$!  codvmix         Enable cod vertical mixing. (only with codunlim or codlim)
$!  gridold         Recover old algorithm for setting vertical coordinates.
$!  nest2larger     Two-way nesting to larger grid via PVM.
$!  nest2smaller    Two-way nesting to smaller grid via PVM.
$!  nest_ext2lrgr   Replace fine grid transport streamfunction with coarse
$!  nest_ext2smlr   Send transport streamfunction to overwrite fine grid
$!  nesttime        Times various elements of the run.  (SUN only)
$!  nkfix           Revise protections & input for Niiler-Kraus mixed-layer.
$!  pindex          Revised streamfunction filter indices.
$!  posmxtid        Sets (tidal) vertical mixing in pre-defined areas and
$!                    over given depth range.
$!  rivsrc          River sources.  Use with PTTRCSRC
$!  shapnocoastflux Revised filter BCs.
$!  tide_zero       Adds tidal Reynolds stresses (zero freq.) to momemtum
$!                    equations. (only with ext_tide)
$!
$!  cod_ing         CJL's modified cod model.  Requires "codlim" also active.
$!  zoo_ing         zooplankton following behavior for CJL's cod
$!  cod_square      speed-response is the square functional
$!  AsselinFilt     Add Asselin filter
$!  AsselinFilt_cod Only apply Asselin filter to cod
$!                                                                        !
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!!!!!!!!!!!!!!!!!!!!!!!! USERS's tunable definitions !!!!!!!!!!!!!!!!!!!!!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!  Directory paths:
$!
$  define/nolog   pebin$dir   [...bin]
$  define/nolog   pe$bin      pebin$dir:pemodel.exe
$!
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!!!!!!!!!!!!!!!!!!!!!! End USERS's tunable definitions !!!!!!!!!!!!!!!!!!!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$goto proceed
$!
$@compile ocean.F
$@compile addtide.F
$@compile all_uc.F
$@compile anaflds.F
$@compile aphread.F
$@compile assiwght.F
$@compile bdryindx.F
$@compile bes1d.F
$@compile bess1d.F
$@compile bess2d.F
$@compile bess2d_msk.F
$@compile bess2d_pmsk.F
$@compile blkdat.F
$@compile boundary.F
$@compile bracket_z.F
$@compile caldate.F
$@compile cdfout.F
$@compile cdrspv.F
$@compile cell_ok.F
$@compile cfl.F
$@compile check_prf.F
$@compile chkparm.F
$@compile clinic.F
$@compile cnvmix.F
$@compile day_code.F
$@compile defbias.F
$@compile defnrg.F
$@compile defout.F
$@compile depthlev.F
$@compile depthslab.F
$@compile derivs0.F
$@compile diag.F
$@compile drftdv.F
$@compile drifters.F
$@compile errio.F
$@compile exitus.F
$@compile extrap.F
$@compile extrap2.F
$@compile file_chk.F
$@compile flip.F
$@compile fsigma.F
$@compile get_date.F
$@compile get_ewpt.F
$@compile get_thick.F
$@compile grad24_p.F
$@compile gregorian.F
$@compile headln.F
$@compile hopsrecv.F
$@compile host_check.F
$@compile hvgrid.F
$@compile ind_bdy.F
$@compile infld.F
$@compile init_srch.F
$@compile inittdpth.F
$@compile inparm.F
$@compile int_gradrho.F
$@compile invtri.F
$@compile ip2ij.F
$@compile landsea.F
$@compile lap_depth.F
$@compile lap_filt.F
$@compile lap_lev.F
$@compile length.F
$@compile lintrp.F
$@compile lintslab.F
$@compile ll2xy.F
$@compile lnblk.F
$@compile load_sig.F
$@compile meanrho.F
$@compile msk_bdy.F
$@compile nest_domain.F
$@compile nest_errchk.F
$@compile nest_flags.F
$@compile nest_init.F
$@compile nest_interior.F
$@compile nest_rec_bc.F
$@compile nest_snd_bc.F
$@compile nest_spawn.F
$@compile nest_t_align.F
$@compile nest_test.F
$@compile no_digit.F
$@compile odam.F
$@compile oiassi.F
$@compile oibndry.F
$@compile okeep.F
$@compile osav.F
$@compile pb0wrtcdf.F
$@compile ppmix.F
$@compile press_bias.F
$@compile press_bias0.F
$@compile priprod.F
$@compile read_tide.F
$@compile readgrids.F
$@compile readprf.F
$@compile readvbc.F
$@compile relax.F
$@compile rem_llist.F
$@compile reset_t_thickness.F
$@compile rich_no.F
$@compile rk40.F
$@compile robc.F
$@compile rotangle.F
$@compile rotparm.F
$@compile rseterr.F
$@compile scalvcln.F
$@compile set_brlx.F
$!
$!  Only want one of the following 2:
$!     use  set_depths.F      without CPP option "gridold"
$!     use  set_depths_old.F  with    CPP option "gridold"
$!
$@compile set_depths.F
$!@compile set_depths_old.F
$!
$@compile set_edges.F
$@compile set_pmask.F
$@compile setvbc.F
$@compile setvert.F
$@compile shap_lev.F
$@compile shap_mean.F
$@compile sig2z.F
$@compile sig_search.F
$@compile sigma2z.F
$@compile spline.F
$@compile splineslab.F
$@compile splint.F
$@compile splintslab.F
$@compile state.F
$@compile step.F
$@compile tid_indx.F
$@compile tide_aux.F
$@compile tide_depth.F
$@compile tide_val.F
$@compile tracer.F
$@compile trackbound.F
$@compile trackinit.F
$@compile trackrefresh.F
$@compile tracksout.F
$@compile trackstep.F
$@compile trackup.F
$@compile trkvscl.F
$@compile tsource.F
$@compile upbox.F
$@compile userdiag.F
$@compile vavgv.F
$@compile vbar_test.F
$@compile vmix_aux.F
$@compile vntrpv.F
$@compile writehydro.F
$@compile wrt_prf.F
$@compile wrtcdf.F
$@compile wrtstr.F
$@compile xtr_psi.F
$@compile xtr_trc.F
$@compile xtr_vel.F
$@compile xtr_vor.F
$@compile xtract.F
$@compile xtrsubdom.F
$@compile xy2ll.F
$@compile zetabar.F
$!
$!  Pick at most one of the following sets of biological routines
$!
$!@compile bioparmAnder.F
$!@compile biosourceAnder.F
$!@compile defbparmAnder.F
$!@compile putbparmAnder.F
$!
$!@compile bioparmDuse.F
$!@compile biosourceDuse.F
$!@compile defbparmDuse.F
$!@compile putbparmDuse.F
$!
$!@compile bioparmFasham.F
$!@compile biosourceFasham.F
$!@compile defbparmFasham.F
$!@compile putbparmFasham.F
$!
$!@compile bioparmMcGillic.F
$!@compile biosourceMcGillic.F
$!@compile defbparmMcGillic.F
$!@compile putbparmMcGillic.F
$!
$proceed:
$ set ver
$ DEFINE  LNK$LIBRARY  SYS$LIBRARY:VAXCRTL
$ link/executable=PE_MODEL	ocean,					-
	addtide,		all_uc,		anaflds,	aphread, -
	assiwght,		bdryindx,	bes1d,		bess1d, -
	bess2d,			bess2d_msk,	bess2d_pmsk,	blkdat, -
	boundary,		bracket_z,	caldate,	cdfout, -
	cdrspv,			cell_ok,	cfl,		check_prf, -
	chkparm,		clinic,		cnvmix,		day_code, -
	defbias,		defnrg,		defout,		depthlev, -
	depthslab,		derivs0,	diag,		drftdv, -
	drifters,		errio,		exitus,		extrap, -
	extrap2,		file_chk,	flip,		fsigma, -
	get_date,		get_ewpt,	get_thick,	grad24_p, -
	gregorian,		headln,		hopsrecv,	host_check, -
	hvgrid,			ind_bdy,	infld,		init_srch, -
	inittdpth,		inparm,		int_gradrho,	invtri, -
	ip2ij,			landsea,	lap_depth,	lap_filt, -
	lap_lev,		length,		lintrp,		lintslab, -
	ll2xy,			lnblk,		load_sig,	meanrho, -
	msk_bdy,		nest_domain,	nest_errchk,	nest_flags, -
	nest_init,		nest_interior,	nest_rec_bc,	nest_snd_bc, -
	nest_spawn,		nest_t_align,	nest_test,	no_digit, -
	odam,			oiassi,		oibndry,	okeep, -
	osav,			pb0wrtcdf,	ppmix,		press_bias, -
	press_bias0,		priprod,	read_tide,	readgrids, -
	readprf,		readvbc,	relax,		rem_llist, -
	reset_t_thickness,	rich_no,	rk40,		robc, -
	rotangle,		rotparm,	rseterr,	scalvcln, -
	set_brlx,		set_depths,	set_edges,	set_pmask, -
	setvbc,			setvert,	shap_lev,	shap_mean, -
	sig2z,			sig_search,	sigma2z,	spline,	-
	splineslab,		splint,		splintslab,	state,	-
	step,			tid_indx,	tide_aux,	tide_depth, -
	tide_val,		tracer,		trackbound,	trackinit, -
	trackrefresh,		tracksout,	trackstep,	trackup, -
	trkvscl,		tsource,	upbox,		userdiag, -
	vavgv,			vbar_test,	vmix_aux,	vntrpv, -
	writehydro,		wrt_prf,	wrtcdf,		wrtstr,	-
	xtr_psi,		xtr_trc,	xtr_vel,	xtr_vor, -
	xtract,			xtrsubdom,	xy2ll,		zetabar, -
				SYS$USRROOT2:[GUEST.LIB]NETCDF.OLB/lib
$!
$ exit
