      subroutine addtide (upe,vpe,utide,vtide,ucombo,vcombo)
c
c=======================================================================
c                                                                    ===
c  This routine combines the velocity compute by the PE model with   ===
c  the tidal velocity.                                               ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     UPE      Zonal component of PE velocity.  (cm/s)               ===
c     VPE      Meridional component of PE velocity.  (cm/s)          ===
c     UTIDE    Zonal component of tidal velocity.  (cm/s)            ===
c     VTIDE    Meridional component of tidal velocity.  (cm/s)       ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     UCOMBO   Zonal component of combined velocity.  (cm/s)         ===
c     VCOMBO   Meridional component of combined velocity.  (cm/s)    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,k
      FLOAT
     *      upe(imt,km),ucombo(imt,km),utide(imt,km),
     *      vpe(imt,km),vcombo(imt,km),vtide(imt,km)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      do 10 k = 1, km
      do 10 i = 1, imt
         ucombo(i,k) = upe(i,k) + utide(i,k)
         vcombo(i,k) = vpe(i,k) + vtide(i,k)
  10  continue
c
      return
      end
