      subroutine aphread
c
c=======================================================================
c                                                                    ===
c  This routine reads in values of the absorption coefficients for   ===
c  the five pigment classes in the bidigare model                    ===
c                                                                    ===
c  Calls:  ERRIO,  EXITUS,  LENGTH                                   ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cdefs.h>
#include <iounits.h>
#include <pconst.h>
#include <cbiopnh.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ios,lenstr,sbgn,send
      FLOAT
     *      achla0,achla1,achlb0,achlb1,achlc0,achlc1,appc0,appc1,apsc0,
     *             apsc1,lambda,lambda0,lambda1,dummy,fac1,lmdares
      character*80 mess
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      lambda=lmdamin
      lmdares=(lmdamax-lmdamin)/(lm-1.0)
c
c-----------------------------------------------------------------------
c  Open absorption coefficient input file.
c-----------------------------------------------------------------------
c
      call length (absonam,lenstr,sbgn,send)
c
      if (lenstr.gt.0) then
         open (absinp, file=absonam(sbgn:send), form='formatted',
     *         status='old', iostat=ios)
       else
         write (stdout,900)
         call exitus ('APHREAD')
      end if
c
      if (ios.ne.0) then
         write (stdout,910) absonam(sbgn:send),ios
         call exitus ('APHREAD')
      end if
c
c-----------------------------------------------------------------------
c  Read absorption coefficients.
c-----------------------------------------------------------------------
c
      read(absinp,*,iostat=ios) lambda0,achla0,achlb0,achlc0,apsc0,
     &                          appc0,dummy,dummy
      call errio (stdout,'APHREAD','reading first line of absorption '//
     &            'data',ios)
c
      read(absinp,*,iostat=ios) lambda1,achla1,achlb1,achlc1,apsc1,
     &                          appc1,dummy,dummy
      call errio (stdout,'APHREAD','reading second line of '//
     &            'absorption data',ios)
c
      do 20 i=1,lm
        if (lambda.le.lambda0) then
          achla(i)=achla0
          achlb(i)=achlb0
          achlc(i)=achlc0
          apsc(i)=apsc0
          appc(i)=appc0
        else
          if (lambda.le.lambda1) then
            fac1=(lambda-lambda0)/(lambda1-lambda0)
            achla(i)=achla0+fac1*(achla1-achla0)
            achlb(i)=achlb0+fac1*(achlb1-achlb0)
            achlc(i)=achlc0+fac1*(achlc1-achlc0)
            apsc(i)=apsc0+fac1*(apsc1-apsc0)
            appc(i)=appc0+fac1*(appc1-appc0)
          else
            do 10 while (lambda.gt.lambda1)
              lambda0=lambda1
              achla0=achla1
              achlb0=achlb1
              achlc0=achlc1
              apsc0=apsc1
              appc0=appc1
              read(absinp,*,iostat=ios) lambda1,achla1,achlb1,achlc1,
     &                                  apsc1,appc1,dummy,dummy
              write (mess,920) lambda0
              call errio (stdout,'APHREAD',mess,ios)
 10         continue
            fac1=(lambda-lambda0)/(lambda1-lambda0)
            achla(i)=achla0+fac1*(achla1-achla0)
            achlb(i)=achlb0+fac1*(achlb1-achlb0)
            achlc(i)=achlc0+fac1*(achlc1-achlc0)
            apsc(i)=apsc0+fac1*(apsc1-apsc0)
            appc(i)=appc0+fac1*(appc1-appc0)          
          endif
        endif
        lambda=lambda+lmdares
 20   continue
c
      close (absinp)
c
      return
c
 900  format (/'***Error:  APHREAD - invalid file name, all blanks.')
 910  format (/'***Error:  APHREAD - unable to open input file:'/11x,
     &        1h",a,1h"/11x,'error code: ',i10)
 920  format ('reading line after wavelength ',1pg15.8)
c
      end
